% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mfp_step.R
\name{select_ic}
\alias{select_ic}
\alias{select_ic_acd}
\title{Function selection procedure based on information criteria}
\usage{
select_ic(
  x,
  xi,
  keep,
  degree,
  acdx,
  y,
  powers_current,
  powers,
  criterion,
  ftest,
  select,
  alpha,
  family,
  ...
)

select_ic_acd(
  x,
  xi,
  keep,
  degree,
  acdx,
  y,
  powers_current,
  powers,
  criterion,
  ftest,
  select,
  alpha,
  family,
  ...
)
}
\arguments{
\item{x}{an input matrix of dimensions nobs x nvars. Does not contain
intercept, but columns are already expanded into dummy variables as
necessary. Data are assumed to be shifted and scaled.}

\item{xi}{a character string indicating the name of the current variable
of interest, for which the best fractional polynomial transformation is
to be estimated in the current step.}

\item{keep}{a character vector with names of variables to be kept
in the model.}

\item{degree}{integer > 0 giving the degree for the FP transformation.}

\item{acdx}{a logical vector of length nvars indicating continuous variables
to undergo the approximate cumulative distribution (ACD) transformation.}

\item{y}{a vector for the response variable or a \code{Surv} object.}

\item{powers_current}{a list of length equal to the number of variables,
indicating the fp powers to be used in the current step for all variables
(except \code{xi}).}

\item{powers}{a named list of numeric values that sets the permitted FP
powers for each covariate.}

\item{criterion}{a character string defining the criterion used to select
variables and FP models of different degrees.}

\item{ftest}{a logical indicating the use of the F-test for Gaussian models.}

\item{select}{a numeric value indicating the significance level
for backward elimination of \code{xi}.}

\item{alpha}{a numeric value indicating the significance level
for tests between FP models of different degrees for \code{xi}.}

\item{family}{a character string representing a family object.}

\item{...}{passed to fitting functions.}
}
\value{
A list with several components:
\itemize{
\item \code{keep}: logical indicating if \code{xi} is forced into model.
\item \code{acd}: logical indicating if an ACD transformation was applied for \code{xi},
i.e. \code{FALSE} in this case.
\item \code{powers}: (best) fp powers investigated in step, indexing \code{metrics}.
Ordered by increasing complexity, i.e. null, linear, FP1, FP2 and so on.
For ACD transformation, it is null, linear, linear(., A(x)), FP1(x, .),
FP1(., A(x)) and FP1(x, A(x)).
\item \code{power_best}: a numeric vector with the best power found. The returned
best power may be \code{NA}, indicating the variable has been removed from the
model.
\item \code{metrics}: a matrix with performance indices for all best models
investigated. Same number of rows as, and indexed by, \code{powers}.
\item \code{model_best}: row index of best model in \code{metrics}.
\item \code{pvalue}: p-value for comparison of linear and null model, \code{NA} in this
case..
\item \code{statistic}: test statistic used, depends on \code{ftest}, \code{NA} in this
case.
}
}
\description{
Used in \code{\link[=find_best_fp_step]{find_best_fp_step()}} when \code{criterion = "aic"} or \code{"bic"}.
For parameter explanations, see \code{\link[=find_best_fp_step]{find_best_fp_step()}}. All parameters
captured by \code{...} are passed on to \code{\link[=fit_model]{fit_model()}}.
}
\details{
In case an information criterion is used to select the best model the
selection procedure simply fits all relevant models and selects the best
one according to the given criterion.

"Relevant" models for a given degree are the null model excluding the
variable of interest, the linear model and all best FP models up to the
specified degree.

In case an ACD transformation is requested, then the models assessed
are the null model, the linear model in x and A(x), the best FP1 models in
x and A(x), and the best FP1(x, A(x)) model.

Note that the "best" FPx model used in this function are given by the models
using a FPx transformation for the variable of interest and having the
highest likelihood of all such models given the current powers for all other
variables, as outlined in Section 4.8 of Royston and Sauerbrei (2008).
These best FPx models are computed in \code{\link[=find_best_fpm_step]{find_best_fpm_step()}}.
Keep in mind that for a fixed number of degrees of freedom (i.e. fixed m),
the model with the highest likelihood is the same as the model with the best
information criterion of any kind since all the models share the same
penalty term.

When a variable is forced into the model by including it in \code{keep}, then
this function will not exclude it from the model (by setting its power to
\code{NA}), but will only choose its functional form.
}
\section{Functions}{
\itemize{
\item \code{select_ic_acd()}: Function to select ACD based transformation.

}}
\seealso{
\code{\link[=select_ra2]{select_ra2()}}
}
