% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Class_Species.R
\name{metaRangeSpecies}
\alias{metaRangeSpecies}
\title{metaRangeSpecies object}
\value{
A \verb{<metaRangeSpecies>} object.
}
\description{
Creates an species object in form of an
\link[R6:R6Class]{R6} class that stores and handles all the individual parts
that define a species.
}
\examples{

## ------------------------------------------------
## Method `metaRangeSpecies$new`
## ------------------------------------------------

# The following is bad practice, since species should be added to a simulation
# via the add_species method of the simulation object. But for illustration
# purposes:
sim_env <- terra::sds(terra::rast(vals = 1, nrow = 2, ncol = 2))
test_sim <- metaRangeSimulation$new(source_environment = sim_env)
sp <- metaRangeSpecies$new(name = "species_01", sim = test_sim)
sp
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{name}}{\verb{<string>} name or ID of the species.}

\item{\code{processes}}{\verb{<list>} of \verb{<metaRangeProcesses>}.
The processes that describe how the species interacts
with the environment, itself and other species.}

\item{\code{traits}}{\verb{<environment>} holds the traits of the species.}

\item{\code{sim}}{\verb{<metaRangeSimulation>} A reference to the \link{metaRangeSimulation}
simulation object that the species is part of.
Useful to access environmental data or data of other species.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-metaRangeSpecies-new}{\code{metaRangeSpecies$new()}}
\item \href{#method-metaRangeSpecies-print}{\code{metaRangeSpecies$print()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-metaRangeSpecies-new"></a>}}
\if{latex}{\out{\hypertarget{method-metaRangeSpecies-new}{}}}
\subsection{Method \code{new()}}{
Creates a new \link{metaRangeSpecies} object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{metaRangeSpecies$new(name, sim)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{\verb{<string>} name or ID of the species.}

\item{\code{sim}}{\verb{<metaRangeSimulation>} A reference to the \link{metaRangeSimulation}
simulation object that the species is part of.
Useful to access environmental data or data of other species.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \verb{<metaRangeSpecies>} object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{# The following is bad practice, since species should be added to a simulation
# via the add_species method of the simulation object. But for illustration
# purposes:
sim_env <- terra::sds(terra::rast(vals = 1, nrow = 2, ncol = 2))
test_sim <- metaRangeSimulation$new(source_environment = sim_env)
sp <- metaRangeSpecies$new(name = "species_01", sim = test_sim)
sp
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-metaRangeSpecies-print"></a>}}
\if{latex}{\out{\hypertarget{method-metaRangeSpecies-print}{}}}
\subsection{Method \code{print()}}{
Prints information about the species to the console
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{metaRangeSpecies$print()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
\verb{<invisible self>}
}
}
}
