% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Class_Process.R
\name{metaRangeProcess}
\alias{metaRangeProcess}
\title{metaRangeProcess object}
\value{
\verb{<metaRangeProcess>} A \link{metaRangeProcess} object.
}
\description{
Creates an metaRangeProcess object in form of an
\link[R6:R6Class]{R6} class that stores and handles all the individual parts
that define a process.
}
\examples{

## ------------------------------------------------
## Method `metaRangeProcess$new`
## ------------------------------------------------

# Note: Only for illustration purposes. Use the add_process method of the
# simulation object to add processes to a simulation.
pr <- metaRangeProcess$new(
   process_name = "ecological_process",
   process_fun = function() {
      cat("Execute ecological process!")
   },
   execution_priority = 1L,
   env = new.env(),
   env_label = "a_species_name"
)
pr

## ------------------------------------------------
## Method `metaRangeProcess$get_PID`
## ------------------------------------------------

pr <- metaRangeProcess$new("A", "1", \() {}, 1, new.env())
pr$get_PID()

## ------------------------------------------------
## Method `metaRangeProcess$get_name`
## ------------------------------------------------

pr <- metaRangeProcess$new("A", "1", \() {}, 1, new.env())
pr$get_name()

## ------------------------------------------------
## Method `metaRangeProcess$get_priority`
## ------------------------------------------------

pr <- metaRangeProcess$new("A", "1", \() {}, 1, new.env())
pr$get_priority()

## ------------------------------------------------
## Method `metaRangeProcess$get_env_label`
## ------------------------------------------------

pr <- metaRangeProcess$new("A", "1", \() {}, 1, new.env(), "human_readable_label")
pr$get_env_label()

## ------------------------------------------------
## Method `metaRangeProcess$print`
## ------------------------------------------------

pr <- metaRangeProcess$new("A", "1", \() {}, 1, new.env())
pr$print()
}
\seealso{
\link{metaRangePriorityQueue}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{fun}}{\verb{<function>} The processes function.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-metaRangeProcess-new}{\code{metaRangeProcess$new()}}
\item \href{#method-metaRangeProcess-get_PID}{\code{metaRangeProcess$get_PID()}}
\item \href{#method-metaRangeProcess-get_name}{\code{metaRangeProcess$get_name()}}
\item \href{#method-metaRangeProcess-get_priority}{\code{metaRangeProcess$get_priority()}}
\item \href{#method-metaRangeProcess-get_env_label}{\code{metaRangeProcess$get_env_label()}}
\item \href{#method-metaRangeProcess-print}{\code{metaRangeProcess$print()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-metaRangeProcess-new"></a>}}
\if{latex}{\out{\hypertarget{method-metaRangeProcess-new}{}}}
\subsection{Method \code{new()}}{
Creates a new \link{metaRangeProcess} object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{metaRangeProcess$new(
  process_name,
  id = "",
  process_fun,
  execution_priority,
  env,
  env_label = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{process_name}}{\verb{<string>} name of the process.}

\item{\code{id}}{\verb{<string>} optional ID of the process.}

\item{\code{process_fun}}{\verb{<function>} The function to be
called when the process is executed. This function will be executed
in the specified environment (see argument: env) and has access to all the
variables in that environment. This function may not have any arguments,
i.e. \code{is.null(formals(process_fun))} must be \code{TRUE}.}

\item{\code{execution_priority}}{\verb{<integer>} the priority of the process.
The lower the number the earlier the process is executed.
Note that the priority is only used to sort the processes
in the priority queue. The actual execution order is determined
by the order of the processes in the queue.}

\item{\code{env}}{\verb{<environment>} the environment where the process should be executed.}

\item{\code{env_label}}{\verb{<string>} optional name of the execution environment.
Just used as a human readable label for debug purposes.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\verb{<metaRangeProcess>} A \link{metaRangeProcess} object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{# Note: Only for illustration purposes. Use the add_process method of the
# simulation object to add processes to a simulation.
pr <- metaRangeProcess$new(
   process_name = "ecological_process",
   process_fun = function() {
      cat("Execute ecological process!")
   },
   execution_priority = 1L,
   env = new.env(),
   env_label = "a_species_name"
)
pr
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-metaRangeProcess-get_PID"></a>}}
\if{latex}{\out{\hypertarget{method-metaRangeProcess-get_PID}{}}}
\subsection{Method \code{get_PID()}}{
get the process ID
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{metaRangeProcess$get_PID()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
\verb{<string>} The process ID
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{pr <- metaRangeProcess$new("A", "1", \() {}, 1, new.env())
pr$get_PID()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-metaRangeProcess-get_name"></a>}}
\if{latex}{\out{\hypertarget{method-metaRangeProcess-get_name}{}}}
\subsection{Method \code{get_name()}}{
get the process name
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{metaRangeProcess$get_name()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
\verb{<string>} The process name
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{pr <- metaRangeProcess$new("A", "1", \() {}, 1, new.env())
pr$get_name()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-metaRangeProcess-get_priority"></a>}}
\if{latex}{\out{\hypertarget{method-metaRangeProcess-get_priority}{}}}
\subsection{Method \code{get_priority()}}{
get the process execution priority
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{metaRangeProcess$get_priority()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
\verb{<integer>} The process execution priority
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{pr <- metaRangeProcess$new("A", "1", \() {}, 1, new.env())
pr$get_priority()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-metaRangeProcess-get_env_label"></a>}}
\if{latex}{\out{\hypertarget{method-metaRangeProcess-get_env_label}{}}}
\subsection{Method \code{get_env_label()}}{
get the name of the process execution environment
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{metaRangeProcess$get_env_label()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
\verb{<string>} The name of the process execution environment or NULL
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{pr <- metaRangeProcess$new("A", "1", \() {}, 1, new.env(), "human_readable_label")
pr$get_env_label()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-metaRangeProcess-print"></a>}}
\if{latex}{\out{\hypertarget{method-metaRangeProcess-print}{}}}
\subsection{Method \code{print()}}{
Prints information about the process to the console
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{metaRangeProcess$print()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
\verb{<invisible self>}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{pr <- metaRangeProcess$new("A", "1", \() {}, 1, new.env())
pr$print()
}
\if{html}{\out{</div>}}

}

}
}
