% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api.R
\name{meetupr_req}
\alias{meetupr_req}
\title{Create and Configure a Meetup API Request}
\usage{
meetupr_req(rate_limit = 500/60, cache = TRUE, ...)
}
\arguments{
\item{rate_limit}{A numeric value specifying the maximum number of
requests per second. Defaults to \code{500 / 60} (500 requests per
60 seconds).}

\item{cache}{A logical value indicating whether to cache the OAuth
token on disk. Defaults to \code{TRUE}.}

\item{...}{Additional arguments passed to \code{\link[=meetupr_client]{meetupr_client()}} for
setting up the OAuth client.}
}
\value{
A \code{httr2} request object pre-configured to interact with
the Meetup API.
}
\description{
This function prepares and configures an HTTP request for
interacting with the Meetup API. It handles both interactive and
non-interactive OAuth flows. In interactive mode, it uses OAuth
authorization code flow. In non-interactive mode (CI/CD), it loads
cached tokens.
}
\details{
This function constructs an HTTP POST request directed to the
Meetup API and applies appropriate OAuth authentication. The
function automatically detects whether it's running in an
interactive or non-interactive context:
\itemize{
\item \strong{Interactive}: Uses OAuth authorization code flow with browser
redirect
\item \strong{Non-interactive}: Loads pre-cached token from CI environment
or disk
}
}
\examples{
\dontrun{
req <- meetupr_req(cache = TRUE)

req <- meetupr_req(
  cache = FALSE,
  client_key = "your_client_key",
  client_secret = "your_client_secret"
)
}

}
