% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_media_source.R
\name{get_media_source}
\alias{get_media_source}
\title{Get media by id}
\usage{
get_media_source(media_id, api_key = Sys.getenv("MEDIACLOUD_API_KEY"))
}
\arguments{
\item{media_id}{Positive integer that contains a valid media`` id.}

\item{api_key}{Character string with the API key you get from mediacloud.org.
Passing it is compulsory. Alternatively, function can be
provided from the global environment.}
}
\value{
Data frame with results. See \url{https://github.com/berkmancenter/mediacloud/blob/master/doc/api_2_0_spec/api_2_0_spec.md#media} for field descriptions.
}
\description{
\code{get_media} returns media source by their id. A media source
is one publisher. Every story that can be collected via \code{get_story}
or \code{get_story_list} belongs to one media source.
}
\examples{
\dontrun{
 media_source <- get_media_source(media_id = 604L)
}

}
