% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcwr.R
\name{mcwr_exit}
\alias{mcwr_exit}
\title{Examine last (exit) row of data set}
\usage{
mcwr_exit(data, age, replace = FALSE, update = FALSE, rewards = 0)
}
\arguments{
\item{data}{an mcwr data.frame}

\item{age}{a real number \emph{ageval}.
It specifies the age of the exit row in the data frame. It may or may not exist.
It may not be smaller than the largest age in the data frame.\cr\cr
If \emph{ageval} corresponds to the largest age in the data frame, option \code{replace} must be specified. The
values of the corresponding row are replaced.  Exit transition values for p-variables are set to 1.
Exit transition values for r-variables are left as-is if they are non-missing and option \code{update} is
not used. Otherwise they are set to \emph{rwval}.  Values of all other transitions are set to missing.\cr\cr
If ageval is larger than the largest age in the data frame, a new row will be inserted.  Exit
transitions are set to 1 for p-variables and to rwval for r-variables.  Values of all other
transitions are set to missing.}

\item{replace}{boolean TRUE/FALSE. See option \code{age}.}

\item{update}{boolean TRUE/FALSE. See option \code{age}.}

\item{rewards}{a real number \emph{rwval}.
It determines the rewards value for exit transitions.}
}
\value{
A data.frame, suitable for further processing by \code{mcwr_*()} functions.
}
\description{
\code{mcwr_exit()} allows easy editing and consistency checks of the last (exit) row of an mcwr data frame.
}
\details{
\pkg{mcwr} requires that all data points that do not enter matrix calculations be set to missing in order to avoid
incorrectly set up data. This rule makes the last (exit) row of the mcwr data frame somewhat tedious to manage.
The convenience function \code{mcwr_exit()} makes it easier to create or edit the last (exit) row of the data set.
}
\seealso{
Other mcwr: 
\code{\link{mcwr_check}()},
\code{\link{mcwr_expectancies}()},
\code{\link{mcwr_genvars}()},
\code{\link{mcwr_switch}()}
}
\concept{mcwr}
