% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcwr.R
\name{mcwr_check}
\alias{mcwr_check}
\title{Check mcwr data frame}
\usage{
mcwr_check(data, ij = FALSE, skipexit = FALSE, noexit = FALSE)
}
\arguments{
\item{data}{an mcwr data.frame}

\item{ij}{a boolean TRUE/FALSE. If TRUE, states that data set is in ij-format.}

\item{skipexit}{a boolean TRUE/FALSE. If TRUE, does not check the last row of the data frame.}

\item{noexit}{a boolean TRUE/FALSE. If TRUE, states that the exit row is missing from the data frame.}
}
\value{
a list containing model information. Its named elements are:
\tabular{ll}{
p_exi         \tab  character vector: p-variables in the data set                                          \cr
p_ful         \tab  character vector: full set of p-variables implied by states                            \cr
p_new         \tab  character vector: p-variables that are implied by states but not in the data set       \cr
s_trn         \tab  numeric vector: list of transitions occuring in data set                               \cr
s_frm         \tab  numeric vector: list of from-states                                                    \cr
s_trg         \tab  numeric vector: list of target states                                                  \cr
s_abs         \tab  numeric vector: absorbing state                                                        \cr
s_omt         \tab  numeric vector: states omitted from the model                                          \cr
r_exi         \tab  character vector: r-variables in the data set                                          \cr
r_ful         \tab  character vector: full set of p-variables implied by states                            \cr
r_new         \tab  character vector: r-variables that are implied by states but not in the data set       \cr
r_trn         \tab  character vector: list of transitions covered by existing r-variables                  \cr
s_rcv         \tab  numeric vector: states receiving rewards                                               \cr
s_nrc         \tab  numeric vector: states not receiving rewards                                           \cr
numages       \tab  number of age classes in the model                                                     \cr
agelist       \tab  numeric vector: age classes of the model                                               \cr
ageintervals  \tab  numeric vector: list of lengths of age intervals                                       \cr
hasexit       \tab  TRUE/FALSE: whether data has an exit row
}
}
\description{
Check that mcwr data frame is set up correctly
}
\details{
Run mcwr check to check whether your data frame is a valid mcwr data frame or whether you have to modify
something. It is also run internally by the other mcwr functions, so you are always safe not to be using
incorrectly set up data.

A second use of the functions is to gather comprehensive information about existing and missing model
variables, and more.
}
\seealso{
Other mcwr: 
\code{\link{mcwr_exit}()},
\code{\link{mcwr_expectancies}()},
\code{\link{mcwr_genvars}()},
\code{\link{mcwr_switch}()}
}
\concept{mcwr}
