% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3_utilities.R
\name{mcc_grouping_var}
\alias{mcc_grouping_var}
\title{Get grouping variable name from grouped \code{mcc} object}
\usage{
mcc_grouping_var(x)
}
\arguments{
\item{x}{An \code{mcc} object}
}
\value{
Character string with grouping variable name, or NULL if not grouped
}
\description{
Get grouping variable name from grouped \code{mcc} object
}
\examples{
# Create sample data with groups
library(dplyr)
df <- data.frame(
  id = c(1, 2, 3, 4, 4, 4, 4, 5, 5),
  time = c(8, 1, 5, 2, 6, 7, 8, 3, 3),
  cause = c(0, 0, 2, 1, 1, 1, 0, 1, 2),
  treatment = c("Control", "Control", "Treatment", "Treatment",
                "Treatment", "Treatment", "Treatment", "Control",
                "Control")
) |>
  arrange(id, time)

# Grouped analysis
mcc_grouped <- mcc(df, "id", "time", "cause", by = "treatment")

# Get grouping variable name
mcc_grouping_var(mcc_grouped)  # "treatment"

# Clean up
rm(df, mcc_grouped)

}
