% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MBBE.R
\name{calc_NCA}
\alias{calc_NCA}
\title{Calculate Non-Compartmental Analysis (NCA) Parameters}
\usage{
calc_NCA(
  run_dir,
  ngroups,
  reference_groups,
  test_groups,
  NCA_end_time,
  samp_size
)
}
\arguments{
\item{run_dir}{Character string specifying the path to the run directory.}

\item{ngroups}{Integer specifying the total number of groups (e.g., 4 for an ABBA design).}

\item{reference_groups}{Numeric vector indicating the group IDs that are designated as reference.}

\item{test_groups}{Numeric vector indicating the group IDs that are designated as test.}

\item{NCA_end_time}{Numeric value specifying the end time for calculations of AUClast and AUCinf.}

\item{samp_size}{Integer indicating the sample size or the total number of samples for the analysis.}
}
\value{
The function returns a list containing the derived NCA parameters for each sample.
}
\description{
This function performs Non-Compartmental Analysis (NCA) to derive key pharmacokinetic parameters such as Cmax, AUCinf, and AUClast for specified time intervals.
}
\details{
The \code{calc_NCA} function internally calls \code{getNCA} for each sample in the sequence from 1 to \code{samp_size}. Note that the function is currently executed in a serial manner and is not parallelized.
}
\examples{
\dontrun{
run_dir <- "c:/Workspace/mbbe"
ngroups <- 4
reference_groups <- c(1,2)
test_groups <- c(3,4)
NCA_end_time <- 7
samp_size <- 6
calc_NCA(run_dir, ngroups, reference_groups, test_groups, NCA_end_time, samp_size)
}

}
