% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/advanced.R
\name{condense_matrix}
\alias{condense_matrix}
\title{Halve the dimensions of a matrix}
\usage{
condense_matrix(m, fun = median)
}
\arguments{
\item{m}{A \code{matrix}.}

\item{fun}{A function for summarizing four values that condenses them down to
one value. Default is \code{\link[stats]{median}}.}
}
\value{
A matrix with dimensions half the size of the original matrix, where each
value is a summary of the four corresponding values in the original.
}
\description{
A function to decrease the size of a matrix while attempting to preserve the
original values.
}
\details{
This function can be used for image manipulation and is included for
  the purpose of making mazes from images. PNG images can be read in as
  arrays via \code{png::readPNG} and if the image is too big, this funtion
  can help get it down to a more manageable size.
}
\examples{
m <- outer(1:4, 1:6)
condense_matrix(m)

}
