% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cosinor.R
\name{cosinor}
\alias{cosinor}
\alias{row_cosinor}
\alias{col_cosinor}
\title{Cosinor}
\usage{
row_cosinor(x, t, period = 24)

col_cosinor(x, t, period = 24)
}
\arguments{
\item{x}{numeric matrix.}

\item{t}{a vector specifying time variable for each observation of x.}

\item{period}{oscillation period in the units of \code{t} (default = 24, suitable when inspecting diurnal rhythms with hourly data).}
}
\value{
a data.frame where each row contains the results of a cosinor test
performed on the corresponding row/column of x.\cr\cr
Each row contains the following information (in order):\cr
1. obs - total number of observations\cr
2. mesor - "Midline Estimating Statistic Of Rhythm" - the average value around which the variable oscillates\cr
3. amplitude - difference between mesor and the peak of the rhythm\cr
4. acrophase - time when rhythm reaches its peak\cr
5. rsquared - R-squared\cr
6. df.model - model terms degrees of freedom\cr
7. df.residual - residual degrees of freedom\cr
8. statistic - F statistic for the omnibus test against intercept-only model\cr
9. pvalue - p-value\cr
10. period - the period used within the model\cr
}
\description{
Performs a Cosinor test for periodicity on each row/column of the input matrix.
}
\details{
\code{row_cosinor} - cosinor test on rows.
\code{col_cosinor} - cosinor test on columns.
}
\examples{
wave <- sin(2*pi*1:24/24) + rnorm(24)
row_cosinor(wave, 1:24, 24)

}
\seealso{
\code{\link[cosinor]{cosinor.lm}}
}
\author{
Karolis Koncevičius
}
