context("Beam daily insolation on an inclined surface")
source("utils.R")

# Disable warnings.
Sys.setenv(NET_FLUX_FUNCTION_SHOW_WARNINGS = FALSE)

test_that("H_bi: Beam daily insolation on an inclined surface for beta = phi at VL1", {

  # Tolerance.
  tolerance = 0.03

  # Test input parameters.
  Ls_seq = seq(0, 0, 5)

  # Expect equals all calculations against all expected.
  test_daily_insolation_on_inclined_surface(
    spacecraft = "VL1",
    field = "Hb",
    tolerance = tolerance,
    Ls_seq = seq(0, 355, 5),
    beta_equals_phi = TRUE,
    verbose = FALSE)
})

test_that("H_bi: Beam daily insolation on optimal inclined surface for beta = 6.5° at VL1", {
  
  # Tolerance.
  tolerance = 0.03
  
  # Test input parameters.
  Ls_seq = seq(0, 355, 5) # Areocentric longitude.
  
  # Expect equals all calculations against all expected.
  test_daily_insolation_on_inclined_surface(
    spacecraft = "VL1",
    field = "Hb",
    tolerance = tolerance,
    Ls_seq = Ls_seq,
    beta_equals_phi = FALSE,
    verbose = FALSE)
})


test_that("H_bi: Beam daily insolation on an inclined surface for beta = phi at VL2", {

  # Tolerance.
  tolerance = 0.057

  # Test input parameters.
  Ls_seq = seq(0, 360, 5)

  # Expect equals all calculations against all expected.
  test_daily_insolation_on_inclined_surface(
    spacecraft = "VL2",
    field = "Hb",
    tolerance = tolerance,
    Ls_seq = Ls_seq,
    beta_equals_phi = TRUE,
    verbose = FALSE)
})

test_that("H_bi: Beam daily insolation on optimal inclined surface for beta = 22° at VL2", {

  # Tolerance.
  tolerance = 0.08

  # Test input parameters.
  Ls_seq = seq(0, 355, 5) # Areocentric longitude.

  # Expect equals all calculations against all expected.
  test_daily_insolation_on_inclined_surface(
    spacecraft = "VL2",
    field = "Hb",
    tolerance = tolerance,
    Ls_seq = Ls_seq,
    beta_equals_phi = FALSE,
    verbose = FALSE)
})

test_that("H_bi: gamma_c validation", {
  # Test invalid gamma_c values (out of -180 to 180 range)
  expect_error(
    H_bi(Ls = 90, phi = 22.48, tau = 0.5, beta = 25, gamma_c = 181)
  )

  expect_error(
    H_bi(Ls = 90, phi = 22.48, tau = 0.5, beta = 25, gamma_c = -181)
  )
})
