% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimation.r
\name{estimation}
\alias{estimation}
\title{Master Estimation Function}
\usage{
estimation(
  formula = NULL,
  effect_name = NULL,
  studyID = NULL,
  effectID = NULL,
  variance = NULL,
  data,
  estimation_method = "REML",
  optim_method = "L-BFGS-B",
  structure = "UN",
  varcov_type,
  weights = NULL,
  intercept = FALSE,
  N = NULL,
  missing = "remove",
  robustID = NULL,
  multivariate_covs = NULL,
  tol = 1e-10,
  ...
)
}
\arguments{
\item{formula}{The formula used for specifying the fixed and random structure.
Used for univariate and multilevel structures.}

\item{effect_name}{Character string representing the name of the effect size
column in the data.}

\item{studyID}{Character string representing the study ID}

\item{effectID}{Character string representing the effect size ID}

\item{variance}{Character string representing the name of the variance of the effect size in the data.}

\item{data}{Data used for analysis}

\item{estimation_method}{Type of estimation used, either "REML" or "MLE", REML is the default}

\item{optim_method}{Optimization method that is passed to the optim function.
Default is 'L-BFGS-B'.}

\item{structure}{Between studies covariance structure, default is "UN" or unstructured. See details for more specifics.}

\item{varcov_type}{Type of variance covariance matrix computed. Default is
'cor_weighted' for correlations or 'smd_outcome' for standardized mean differences.}

\item{weights}{User specified matrix of weights.}

\item{intercept}{Whether a model intercept should be specified, default is FALSE
meaning no intercept. See details for more information.}

\item{N}{Character string representing the sample size of the studies.}

\item{missing}{What to do with missing data, default is 'remove'}

\item{robustID}{A character vector specifying the cluster group to use for computing the robust standard errors.}

\item{multivariate_covs}{A one-sided formula to specify the covariates used in a multivariate analysis.}

\item{tol}{Tolerance for estimating, passed to \code{optim}}

\item{...}{Additional arguments to pass to \code{optim}.}
}
\value{
Output is a named list; The output returns the estimated parameters,
fit statistics, estimation inputs.
}
\description{
The primary estimation function for conducting the optimization. The function
is typically called through the \link{mars} function, but can be called here
directly.
}
