
extract_model <- function(model, variable_names) {

  if(is.null(model[['beta_r']])) {
    beta_vector <- model[['beta_fe']]
  } else {
    beta_vector <- model[['beta_r']]
  }
  beta_matrix <- as.matrix(beta_vector)

  B <- corpcor::vec2sm(beta_matrix, diag = FALSE, order = NULL)

  diag(B) <- 1

  column_row_names <- extract_var_names(variable_names)
  rownames(B) <- colnames(B) <- column_row_names


  V <-  model[['varcov_beta']]

  tau2 <-  diag(model[['est_values']][['Tau']])
  rho <-  corpcor::sm2vec(stats::cov2cor(model[['est_values']][['Tau']]))
  # tau_mat <- tau_matrix(rho, tau2)

  list(beta_matrix = B,
       var_matrix = V,
       tau = tau2,
       rho = rho)
}
