% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Ufun.R
\name{Ufun}
\alias{Ufun}
\title{Penalty Function for Penalized Test Functions}
\usage{
Ufun(x, a, k, m)
}
\arguments{
\item{x}{Numeric vector of input values to penalize.}

\item{a}{Threshold value. Penalty is applied when \eqn{|x_i| > a}.}

\item{k}{Penalty coefficient controlling the penalty magnitude.}

\item{m}{Exponent for the penalty term.}
}
\value{
Numeric vector of penalty values (same length as \code{x}).
}
\description{
Helper function used in penalized test functions (F12, F13). This function
applies a penalty when variable values exceed specified bounds.
}
\details{
\strong{Formula:}
\deqn{u(x_i, a, k, m) = \begin{cases}
  k(x_i - a)^m & \text{if } x_i > a \\
  0 & \text{if } -a \leq x_i \leq a \\
  k(-x_i - a)^m & \text{if } x_i < -a
\end{cases}}

The penalty function is zero within the interval \eqn{[-a, a]} and grows
polynomially outside this region. This is used to softly constrain
optimization to a bounded region without hard constraints.
}
\seealso{
\code{\link{F12}}, \code{\link{F13}} for functions that use this helper.
}
\keyword{internal}
