% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_gfw_treecover.R
\name{gfw_treecover}
\alias{gfw_treecover}
\alias{get_gfw_treecover}
\title{Treecover for the year 2000}
\source{
\url{https://data.globalforestwatch.org/documents/tree-cover-2000/explore}
}
\usage{
get_gfw_treecover(version = "GFC-2024-v1.12")
}
\arguments{
\item{version}{The version of the dataset to download. Defaults to
"GFC-2024-v1.12". Check mapme.biodiversity:::.available_gfw_versions()
to get a list of available versions}
}
\value{
A function that returns an \code{sf} footprint object.
}
\description{
This resource is part of the publication by Hansen et al. (2013)
represents "tree cover in the year 2000, defined as canopy closure for all
vegetation taller than 5m in height. Encoded as a percentage per output grid
cell, in the range 0–100." Due to changes in the satellites products used
in the compilation of the treecover product, results before the year 2011
and afterwards are not directly comparable until reprocessing has finished.
Users should be aware of this limitation, especially when the timeframe
of the analysis spans over the two periods delimited by the year 2011.
}
\references{
Hansen, M. C., P. V. Potapov, R. Moore, M. Hancher, S. A.
Turubanova, A. Tyukavina, D. Thau, S. V. Stehman, S. J. Goetz, T. R.
Loveland, A. Kommareddy, A. Egorov, L. Chini, C. O. Justice, and J. R. G.
Townshend. 2013. “High-Resolution Global Maps of 21st-Century Forest Cover
Change.” Science 342 (15 November): 850–53.
}
\keyword{resource}
