% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mark_ties.R
\name{mark_triangles}
\alias{mark_triangles}
\alias{tie_is_triangular}
\alias{tie_is_transitive}
\alias{tie_is_triplet}
\alias{tie_is_cyclical}
\alias{tie_is_simmelian}
\alias{tie_is_forbidden}
\alias{tie_is_imbalanced}
\title{Marking ties based on structural properties}
\usage{
tie_is_triangular(.data)

tie_is_transitive(.data)

tie_is_triplet(.data)

tie_is_cyclical(.data)

tie_is_simmelian(.data)

tie_is_forbidden(.data)

tie_is_imbalanced(.data)
}
\arguments{
\item{.data}{An object of a manynet-consistent class:
\itemize{
\item matrix (adjacency or incidence) from \code{{base}} R
\item edgelist, a data frame from \code{{base}} R or tibble from \code{{tibble}}
\item igraph, from the \code{{igraph}} package
\item network, from the \code{{network}} package
\item tbl_graph, from the \code{{tidygraph}} package
}}
}
\description{
These functions return logical vectors the length of the ties
in a network identifying which hold certain properties or positions in the network.
\itemize{
\item \code{tie_is_triangular()} marks ties that are in triangles.
\item \code{tie_is_cyclical()} marks ties that are in cycles.
\item \code{tie_is_transitive()} marks ties that complete transitive closure.
\item \code{tie_is_triplet()} marks ties that are in a transitive triplet.
\item \code{tie_is_simmelian()} marks ties that are both in a triangle
and fully reciprocated.
}

They are most useful in highlighting parts of the network that
are cohesively connected.
}
\examples{
ison_monks \%>\% to_uniplex("like") \%>\% 
  mutate_ties(tri = tie_is_triangular())
  #graphr(edge_color = "tri")
ison_adolescents \%>\% to_directed() \%>\% 
  mutate_ties(trans = tie_is_transitive())
  #graphr(edge_color = "trans")
ison_adolescents \%>\% to_directed() \%>\% 
  mutate_ties(trip = tie_is_triplet())
  #graphr(edge_color = "trip")
ison_adolescents \%>\% to_directed() \%>\% 
  mutate_ties(cyc = tie_is_cyclical())
  #graphr(edge_color = "cyc")
ison_monks \%>\% to_uniplex("like") \%>\% 
  mutate_ties(simmel = tie_is_simmelian())
  #graphr(edge_color = "simmel")
generate_random(8, directed = TRUE) \%>\% 
  mutate_ties(forbid = tie_is_forbidden())
  #graphr(edge_color = "forbid")
tie_is_imbalanced(to_uniplex(fict_marvel, "relationship"))
}
\seealso{
Other marks: 
\code{\link{mark_diff}},
\code{\link{mark_nodes}},
\code{\link{mark_select}},
\code{\link{mark_tie_select}},
\code{\link{mark_ties}}
}
\concept{marks}
