% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/manip_format.R
\name{manip_direction}
\alias{manip_direction}
\alias{to_directed}
\alias{to_undirected}
\alias{to_redirected}
\alias{to_reciprocated}
\alias{to_acyclic}
\title{Modifying networks by formatting their directionality}
\usage{
to_directed(.data)

to_undirected(.data)

to_redirected(.data)

to_reciprocated(.data)

to_acyclic(.data)
}
\arguments{
\item{.data}{An object of a manynet-consistent class:
\itemize{
\item matrix (adjacency or incidence) from \code{{base}} R
\item edgelist, a data frame from \code{{base}} R or tibble from \code{{tibble}}
\item igraph, from the \code{{igraph}} package
\item network, from the \code{{network}} package
\item tbl_graph, from the \code{{tidygraph}} package
}}
}
\value{
All \code{to_} functions return an object of the same class as that provided.
So passing it an igraph object will return an igraph object
and passing it a network object will return a network object,
with certain modifications as outlined for each function.
}
\description{
These functions reformat manynet-consistent data.
\itemize{
\item \code{to_directed()} reformats undirected network data to a directed network.
\item \code{to_undirected()} reformats directed network data to an undirected network,
so that any pair of nodes with at least one directed edge will be
connected by an undirected edge in the new network.
This is equivalent to the "collapse" mode in \code{{igraph}}..
\item \code{to_redirected()} formats directed network data by flipping/transposing
any existing direction such that senders become receivers and
receivers become senders.
This essentially has no effect on undirected networks or reciprocated ties.
\item \code{to_reciprocated()} reformats directed network data such that every
directed tie is reciprocated.
\item \code{to_acyclic()} reformats network data to an acyclic graph.
}

If the format condition is not met,
for example \code{to_undirected()} is used on a network that is already undirected,
the network data is returned unaltered.
No warning is given so that these functions can be used to ensure conformance.

Unlike the \verb{as_*()} group of functions,
these functions always return the same class as they are given,
only transforming these objects' properties.
}
\details{
Not all functions have methods available for all object classes.
Below are the currently implemented S3 methods:\tabular{lrrrrr}{
    \tab data.frame \tab igraph \tab matrix \tab network \tab tbl_graph \cr
   to_undirected \tab 1 \tab 1 \tab 1 \tab 1 \tab 1 \cr
}
}
\seealso{
Other modifications: 
\code{\link{manip_as}},
\code{\link{manip_correlation}},
\code{\link{manip_deformat}},
\code{\link{manip_from}},
\code{\link{manip_levels}},
\code{\link{manip_miss}},
\code{\link{manip_nodes}},
\code{\link{manip_paths}},
\code{\link{manip_permutation}},
\code{\link{manip_preformat}},
\code{\link{manip_project}},
\code{\link{manip_reformat}},
\code{\link{manip_scope}},
\code{\link{manip_split}},
\code{\link{manip_ties}}
}
\concept{modifications}
