% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/maidr_widget.R
\name{maidr_widget}
\alias{maidr_widget}
\title{Create MAIDR htmlwidget}
\usage{
maidr_widget(plot, width = NULL, height = NULL, element_id = NULL, ...)
}
\arguments{
\item{plot}{A ggplot object to render as an interactive MAIDR widget}

\item{width}{The width of the widget in pixels or CSS units (default: NULL for auto-sizing)}

\item{height}{The height of the widget in pixels or CSS units (default: NULL for auto-sizing)}

\item{element_id}{A unique identifier for the widget (default: NULL for auto-generated)}

\item{...}{Additional arguments passed to create_maidr_html()}
}
\value{
An htmlwidget object that can be displayed in RStudio, Shiny, or saved as HTML
}
\description{
Internal function that creates an interactive MAIDR widget from a ggplot object.
This is called internally by render_maidr() and should not be called directly.
Use maidr_output() and render_maidr() for Shiny integration instead.
}
\details{
Uses iframe-based isolation to ensure MAIDR.js initializes properly.
Each widget gets its own isolated JavaScript context where MAIDR.js
can discover and initialize the SVG with maidr-data attribute.
}
\keyword{internal}
