% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exposure_related_functions.R
\name{write_exposure}
\alias{write_exposure}
\title{Write an exposure matrix to a file.}
\usage{
write_exposure(exposure, file, row.names = TRUE)
}
\arguments{
\item{exposure}{Exposures as a numerical matrix (or data.frame) with
signatures in rows and samples in columns. Rownames are taken as the
signature names and column names are taken as the sample IDs.}

\item{file}{File to which to write the exposure matrix (as a CSV file).}

\item{row.names}{Either a logical value indicating whether the row names of
\code{exposure} are to be written along with \code{exposure}, or a
character vector of row names to be written.}
}
\value{
No return value, called for side effects.
}
\description{
Write an exposure matrix to a file.
}
\examples{
file <- system.file("extdata",
  "Liver-HCC.exposure.csv",
  package = "mSigTools"
)
exposure <- read_exposure(file)
write_exposure(exposure, file = file.path(tempdir(), "Liver-HCC.exposure.csv"))
}
