% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exposure_related_functions.R
\name{sort_exposure}
\alias{sort_exposure}
\title{Sort columns of an exposure matrix based on the number of mutations in each sample (column).}
\usage{
sort_exposure(exposure, decreasing = TRUE)
}
\arguments{
\item{exposure}{Exposures as a numerical matrix (or data.frame) with
signatures in rows and samples in columns. Rownames are taken as the
signature names and column names are taken as the sample IDs.}

\item{decreasing}{If \code{TRUE}, sort from largest to smallest.}
}
\value{
The original \code{exposure} with columns sorted.
}
\description{
Sort columns of an exposure matrix based on the number of mutations in each sample (column).
}
\examples{
file <- system.file("extdata",
  "Liver-HCC.exposure.csv",
  package = "mSigTools"
)
exposure <- read_exposure(file)
exposure.sorted <- sort_exposure(exposure)
}
