% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{which.cp}
\alias{which.cp}
\title{Find locations of change points}
\usage{
which.cp(y1, chest, level = 0.1)
}
\arguments{
\item{y1}{a vector of the differential of sequence Y}

\item{chest}{output of function \code{\link{ch.est}}}

\item{level}{FDR control level}
}
\value{
a list of components
\item{peak}{a vector of peaks location}
\item{vall}{a vector of valleys location}
\item{pval}{a scalar of adjusted p-value based on FDR control}
\item{thresh}{a scalar of threshold for \code{y1}}
}
\description{
Find locations of change points
}
\examples{
mu = GenMu(x=1:10,pos=seq(10,100,10),size=150)
z = GenZ(nu=2,size=150)
y1 = GenDY(mu,z,gamma=4)
chest = ch.est(nu=2,gamma=8,size=150,B=100)
which.cp(y1,chest,level=0.1)
}
\seealso{
\code{\link{ch.est}}/\code{\link{fdrBH}}
}
