% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lookup.R
\name{lookup}
\alias{lookup}
\title{Lookup items in key-value pairs of vectors}
\usage{
lookup(x, key, value, nomatch = NA)
}
\arguments{
\item{x}{Vector of items to lookup in key-value pairs.}

\item{key}{Vector of keys that are searched.}

\item{value}{Vector of values to be returned.}

\item{nomatch}{The value to be returned in the case when no match is
found. Note that it is coerced to integer.}
}
\value{
A vector the same length as \code{x}, but containing the values
of \code{value}.  If \code{x[i]} is equal to \code{key[j]}, then the
value returned in the ith position of the vector is \code{value[j]}.
If no match is found, \code{NA} is returned.
}
\description{
This is a simple wrapper to the \code{match} function.
}
\details{
Search for elements of \code{x} in \code{key} and return the corresponding
element of \code{value}.
If no match is found, return \code{nomatch}.
}
\examples{
# Example 1.  A and B have different factor levels
A <- factor(c("A","E","F"))
B <- factor(c("E","F","G"))
v <- c(4,2,0)
lookup(A,B,v)

# Example 2.  Merge treatment means back into the raw data
dat <- data.frame(Trt = rep(LETTERS[1:5],2),
                  x=round(rnorm(10),2))
# Treatment B is missing all values, treatment D missing one value
dat$x[dat$Trt=="B"] <- NA
dat$x[4] <- NA
# Calculate treatment means
TrtMean <- tapply(dat$x, dat$Trt, mean, na.rm=TRUE)
TrtMean
# Merge the means into the original data
dat$TrtMean <- lookup(dat$Trt, names(TrtMean), TrtMean)

}
\author{
Kevin Wright
}
