% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zzz.R
\docType{package}
\name{localLLM-package}
\alias{localLLM-package}
\alias{localLLM}
\title{R Interface to llama.cpp with Runtime Library Loading}
\description{
Provides R bindings to the llama.cpp library for running large language models locally.
This package uses an innovative lightweight architecture where the C++ backend library 
is downloaded at runtime rather than bundled with the package, enabling zero-configuration
AI inference in R with enterprise-grade performance.
}
\details{
The localLLM package brings state-of-the-art language models to R users through a
carefully designed four-layer architecture that combines ease of use with high performance.

## Quick Start
1. Install the R package: \code{install.packages("localLLM")}
2. Download backend library: \code{install_localLLM()}
3. Start generating text: \code{quick_llama("Hello, how are you?")}

## Key Features
\itemize{
  \item \strong{Zero Configuration}: One-line setup with automatic model downloading
  \item \strong{High Performance}: Native C++ inference engine with GPU support
  \item \strong{Cross Platform}: Pre-compiled binaries for Windows, macOS, and Linux
  \item \strong{Memory Efficient}: Smart caching and memory management
  \item \strong{Production Ready}: Robust error handling and comprehensive documentation
}

## Architecture Overview
The package uses a layered design:
\itemize{
  \item \strong{High-Level API}: \code{\link{quick_llama}} for simple text generation
  \item \strong{Mid-Level API}: \code{\link{model_load}}, \code{\link{generate}} for detailed control
  \item \strong{Low-Level API}: Direct access to tokenization and context management
  \item \strong{C++ Backend}: llama.cpp engine with dynamic loading
}

## Main Functions
\itemize{
  \item \code{\link{install_localLLM}} - Download and install backend library
  \item \code{\link{quick_llama}} - High-level text generation (recommended for beginners)
  \item \code{\link{model_load}} - Load GGUF models with smart caching
  \item \code{\link{context_create}} - Create inference contexts
  \item \code{\link{generate}} - Generate text with full parameter control
  \item \code{\link{tokenize}} / \code{\link{detokenize}} - Text <-> Token conversion
  \item \code{\link{apply_chat_template}} - Format conversations for chat models
}

## Example Workflows

### Basic Text Generation
\preformatted{
# Simple one-liner
response <- quick_llama("Explain quantum computing")

# With custom parameters
creative_text <- quick_llama("Write a poem about AI", 
                             temperature = 0.9, 
                             max_tokens = 150)
}

### Advanced Usage with Custom Models
\preformatted{
# Load your own model
model <- model_load("path/to/your/model.gguf")
ctx <- context_create(model, n_ctx = 4096)

# Direct text generation with auto-tokenization
output <- generate(ctx, "The future of AI is", max_tokens = 100)
}

### Batch Processing
\preformatted{
# Process multiple prompts efficiently
prompts <- c("Summarize AI trends", "Explain machine learning", "What is deep learning?")
responses <- quick_llama(prompts)
}

## Supported Model Formats
The package works with GGUF format models from various sources:
\itemize{
  \item Hugging Face Hub (automatic download)
  \item Local .gguf files
  \item Custom quantized models
  \item Ollama-compatible models
}

## Performance Tips
\itemize{
  \item Use \code{n_gpu_layers = -1} to fully utilize GPU acceleration
  \item Set \code{n_threads} to match your CPU cores for optimal performance
  \item Use larger \code{n_ctx} values for longer conversations
  \item Enable \code{use_mlock} for frequently used models to prevent swapping
}
}
\references{
\url{https://github.com/EddieYang211/localLLM}
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/EddieYang211/localLLM}
  \item Report bugs at \url{https://github.com/EddieYang211/localLLM/issues}
}

}
\author{
Eddie Yang and Yaosheng Xu <xu2009@purdue.edu>
}
\keyword{package}
