% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api.R
\name{download_model}
\alias{download_model}
\title{Download a model manually}
\usage{
download_model(
  model_url,
  output_path = NULL,
  show_progress = TRUE,
  verify_integrity = TRUE,
  max_retries = 3,
  hf_token = NULL
)
}
\arguments{
\item{model_url}{URL of the model to download (currently only supports https://)}

\item{output_path}{Local path where to save the model (optional, will use cache if not provided)}

\item{show_progress}{Whether to show download progress (default: TRUE)}

\item{verify_integrity}{Verify file integrity after download (default: TRUE)}

\item{max_retries}{Maximum number of download retries (default: 3)}

\item{hf_token}{Optional Hugging Face access token to use for this download. Defaults to the existing `HF_TOKEN` environment variable.}
}
\value{
The path where the model was saved
}
\description{
Download a model manually
}
\examples{
\dontrun{
# Download to specific location
download_model(
  "https://example.com/model.gguf",
  file.path(tempdir(), "my_model.gguf")
)

# Download to cache (path will be returned)
cached_path <- download_model("https://example.com/model.gguf")
}
}
