% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lncDIFF.R
\name{lncDIFF}
\alias{lncDIFF}
\title{lncRNA Differential Expression (DE) analysis}
\usage{
lncDIFF(
  edata,
  group,
  covariate = NULL,
  link.function = "log",
  CompareGroups = NULL,
  simulated.pvalue = FALSE,
  permutation = 100
)
}
\arguments{
\item{edata}{Normalized counts matrix with genes in rows and samples in columns.}

\item{group}{Primary factor of interest in DE analysis, e.g., treatment groups, tissue types, other phenotypes.}

\item{covariate}{Other variables (or covariates) associated with expression level. Input must be a matrix or data frame with each column being a covariate matching to \code{group}}

\item{link.function}{Link function for the generalized linear model, either 'log' or 'identity', default as 'log'.}

\item{CompareGroups}{Labels of treatment groups or phenotypes of interest to be compared in DE analysis. Input must be a vector of \code{group} labels without duplicates.}

\item{simulated.pvalue}{If empirical p-values are computed, simulated.pvalue=TRUE. The default is FALSE.}

\item{permutation}{The number of permutations used in simulating pvalues. The default value is 100.}
}
\value{
\item{DE.results}{Likelihood ratio test results with test statistics, p-value, FDR, DE genes, groupwise mean expression, fold change (if two groups are compared). 
       If simulated.pvalue=TRUE, test.results also includes simulated p-value and FDR.}  
       \item{full.model.fit}{Generalized linear model with zero-inflated Exponential likelihood function, estimating group effect compared to a reference group.}
}
\description{
lncDIFF returns DE analysis results based on lncRNA counts and grouping variables.
}
\examples{

data('hnsc.edata','tissue','cov')  

# DE analysis comparing two groups (normal vs tumor) for 100 genes
result=lncDIFF(edata=hnsc.edata[1:100,],group=tissue,covariate=cov) 

# Recommend at least 50 permutations if simulated.pvalue=TRUE




}
\references{
Li, Q., Yu, X., Chaudhary, R. et al.'lncDIFF: a novel quasi-likelihood method for differential expression analysis of non-coding RNA'. BMC Genomics (2019) 20: 539.
}
