% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract.R
\name{[.listArray}
\alias{[.listArray}
\alias{[<-.listArray}
\title{Extract or Replace one Element of a \code{listArray}}
\usage{
\method{[}{listArray}(x, ...)

\method{[}{listArray}(x, ...) <- value
}
\arguments{
\item{x}{object from which to extract a element or in which to replace a element.}

\item{...}{indices specifying the element to extract or replace. Indices can consist of any R Object.}

\item{value}{value which replaces a \code{listArray} element}
}
\value{
Returns or sets the selected element.
}
\description{
Operators acting on one element of a \code{listArray} to extract or replace it.
}
\examples{
l <- listArray()
l[1] <- 1
l[1]
#
l[2,3] <- "test"
l[2,3]
#
l[2:3] <- "vector"
l[2:3]
l[2,3]
#
l['iris'] <- iris
head(l['iris'])
#
l[letters[1:5]] <- letters[1:5]
l[letters[1:5]]
#
l[mean] <- mean
l[mean](0:10)
}
