% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/any_duplicated_linter.R
\name{any_duplicated_linter}
\alias{any_duplicated_linter}
\title{Require usage of \code{anyDuplicated(x) > 0} over \code{any(duplicated(x))}}
\usage{
any_duplicated_linter()
}
\description{
\code{\link[=anyDuplicated]{anyDuplicated()}} exists as a replacement for \code{any(duplicated(.))}, which is
more efficient for simple objects, and is at worst equally efficient.
Therefore, it should be used in all situations instead of the latter.
}
\details{
Also match usage like \code{length(unique(x$col)) == nrow(x)}, which can
be replaced by \code{anyDuplicated(x$col) == 0L}.
}
\examples{
# will produce lints
lint(
  text = "any(duplicated(x), na.rm = TRUE)",
  linters = any_duplicated_linter()
)

lint(
  text = "length(unique(x)) == length(x)",
  linters = any_duplicated_linter()
)

lint(
  text = "DT[, uniqueN(col) == .N]",
  linters = any_duplicated_linter()
)

# okay
lint(
  text = "anyDuplicated(x)",
  linters = any_duplicated_linter()
)

lint(
  text = "anyDuplicated(x) == 0L",
  linters = any_duplicated_linter()
)

lint(
  text = "anyDuplicated(DT, by = 'col') == 0L",
  linters = any_duplicated_linter()
)

}
\seealso{
\link{linters} for a complete list of linters available in lintr.
}
\section{Tags}{
\link[=best_practices_linters]{best_practices}, \link[=efficiency_linters]{efficiency}
}
