% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grassControl.R
\name{setenvGRASSw}
\alias{setenvGRASSw}
\title{Usually for internally usage, create valid 'GRASS GIS 7.xx' rsession environment settings according to the selected GRASS GIS 7.x and Windows Version}
\usage{
setenvGRASSw(
  root_GRASS,
  grass_version = NULL,
  installation_type = NULL,
  quiet = TRUE
)
}
\arguments{
\item{root_GRASS}{grass root directory i.e. 'C:\\OSGEO4~1',}

\item{grass_version}{grass version name i.e. 'grass-7.0.5'}

\item{installation_type}{two options 'osgeo4w' as installed by the 'OSGeo4W'-installer and 'NSIS' that is typical for a stand_alone installation of 'GRASS GIS'.}

\item{quiet}{boolean  switch for suppressing console messages default is TRUE}
}
\description{
Initializes and set up  access to 'GRASS GIS 7.xx' via the \code{rgrass} wrapper or command line packages. Set and returns all necessary environment variables and additionally returns the GISBASE directory as string.
}
\examples{
\dontrun{
# set selected 'GRASS GIS' installation folders 
setenvGRASSw(root_GRASS = 'C:\\\\PROGRA~1\\\\QGIS2~1.18',
             grass_version =  'grass-7.2.1',
             installation_type =  'osgeo4W')
}
}
\author{
Chris Reudenbach
}
\keyword{internal}
