% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_linelist.R
\name{create_linelist}
\alias{create_linelist}
\title{Create a Line List from Report and Onset Dates}
\usage{
create_linelist(report_dates, onset_dates)
}
\arguments{
\item{report_dates}{A vector of dates representing when cases were reported; must be of type Date.}

\item{onset_dates}{A vector of dates representing when symptoms onset occurred; must be of type Date.
This vector can contain NA values, but not exclusively or none at all.}
}
\value{
A data frame with the following columns: report_dates, delay_int, onset_dates,
        is_weekend, report_int, and week_int. This data frame is ordered by report_dates and
        assigned a class attribute of `lineList`.
}
\description{
This function constructs a line list data frame using vectors of report and onset dates.
It performs several checks and transformations to ensure the data is consistent and
appropriate for epidemiological analysis.
}
\details{
The function ensures the following:
         - The length of `report_dates` and `onset_dates` must be equal.
         - There should be no NA values in `report_dates`.
         - `onset_dates` must contain some but not all NA values.
         - Each non-NA onset date must be earlier than or equal to its corresponding report date.
         If any of these conditions are violated, the function will stop with an error message.
         Additionally, the function calculates the delay in days between onset and report dates,
         identifies weekends, and calculates reporting and week intervals based on the earliest date.
}
\examples{
data("sample_onset_dates")
data("sample_report_dates")
line_list <- create_linelist(sample_report_dates, sample_onset_dates)
}
