# lightsf - Collection of georeferenced and spatial datasets from different domains
# Version 0.1.0
# Copyright (C) 2025 Ingrid Romero Pinilla
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <https://www.gnu.org/licenses/>.

# housing_pts


library(testthat)

# Test 1: Confirm the object is a data.frame
test_that("housing_pts is a data.frame", {
  expect_s3_class(housing_pts, "data.frame")
})

# Test 2: Confirm it has exactly 10 columns
test_that("housing_pts has 10 columns", {
  expect_equal(length(housing_pts), 10)
})

# Test 3: Confirm it has exactly 20640 rows
test_that("housing_pts has 20640 rows", {
  expect_equal(nrow(housing_pts), 20640)
})

# Test 4: Confirm column names are correct
test_that("housing_pts has correct column names", {
  expect_named(housing_pts, c(
    "longitude", "latitude", "housing_median_age",
    "total_rooms", "total_bedrooms", "population",
    "households", "median_income", "median_house_value",
    "ocean_proximity"
  ))
})

# Test 5: Confirm column types are as expected
test_that("housing_pts columns have correct types", {
  expect_type(housing_pts$longitude, "double")
  expect_type(housing_pts$latitude, "double")
  expect_type(housing_pts$housing_median_age, "double")
  expect_type(housing_pts$total_rooms, "double")
  expect_type(housing_pts$total_bedrooms, "double")
  expect_type(housing_pts$population, "double")
  expect_type(housing_pts$households, "double")
  expect_type(housing_pts$median_income, "double")
  expect_type(housing_pts$median_house_value, "double")
  expect_type(housing_pts$ocean_proximity, "character")
})
