% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{baltimore_pts}
\alias{baltimore_pts}
\title{Housing Sales in Baltimore, Maryland (1978)}
\format{
A data frame with 211 observations and 17 variables:
\describe{
  \item{STATION}{Census tract station identifier (integer)}
  \item{PRICE}{House sale price (numeric)}
  \item{NROOM}{Number of rooms (numeric)}
  \item{DWELL}{Dwelling type indicator (numeric)}
  \item{NBATH}{Number of bathrooms (numeric)}
  \item{PATIO}{Presence of patio (numeric indicator)}
  \item{FIREPL}{Presence of fireplace (numeric indicator)}
  \item{AC}{Presence of air conditioning (numeric indicator)}
  \item{BMENT}{Presence of basement (numeric indicator)}
  \item{NSTOR}{Number of stories (numeric)}
  \item{GAR}{Presence of garage (numeric indicator)}
  \item{AGE}{Age of the dwelling (numeric)}
  \item{CITCOU}{City/county indicator (numeric)}
  \item{LOTSZ}{Lot size (numeric)}
  \item{SQFT}{Interior square footage (numeric)}
  \item{X}{X coordinate (numeric)}
  \item{Y}{Y coordinate (numeric)}
}
}
\source{
Data taken from the \pkg{spData} package version 2.3.4.
}
\usage{
data(baltimore_pts)
}
\description{
This dataset, `baltimore_pts`, is a data frame containing housing sales data
and property characteristics for Baltimore, Maryland, in 1978. It has been
widely used in spatial econometrics and hedonic regression studies. Each row
corresponds to a house, including sale price, structural attributes, lot size,
and geographic coordinates (X, Y) on the Maryland grid (projection type
unknown).
}
\details{
The dataset consists of 211 observations (houses) and 17 variables.

The dataset name has been kept as `baltimore_pts` to avoid confusion with
other datasets in the R ecosystem. This naming convention helps distinguish
this dataset as part of the `lightsf` package and assists users in identifying
its specific characteristics. The original content has not been modified in
any way.
}
