% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/galois_field.R
\name{poly_prod}
\alias{poly_prod}
\title{Multiplication in polynomial representation}
\usage{
poly_prod(p, n, xton, p1, p2)
}
\arguments{
\item{p}{modulus}

\item{n}{length of polynomials}

\item{xton}{characteristic polynomial vector for the field (x to the n power)}

\item{p1}{polynomial vector 1}

\item{p2}{polynomial vector 2}
}
\value{
the product of p1 and p2
}
\description{
Multiplication in polynomial representation
}
\examples{
gf <- create_galois_field(4)
a <- poly_prod(gf$p, gf$n, gf$xton, c(1, 0), c(0, 1))
stopifnot(all(a == c(0, 1)))
}
