% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R
\name{summary.felm}
\alias{summary.felm}
\title{Summarize felm model fits}
\usage{
\method{summary}{felm}(
  object,
  ...,
  robust = !is.null(object$clustervar) || getOption("lfe.robust"),
  lhs = NULL
)
}
\arguments{
\item{object}{an object of class \code{"felm"}, a result of a call to
\code{felm}.}

\item{...}{further arguments passed to or from other methods.}

\item{robust}{logical. Use robust standard errors. See notes.}

\item{lhs}{character. If multiple left hand sides, specify the name of the
one to obtain a summary for.}
}
\value{
The function \code{summary.felm} returns an object of \code{class}
\code{"summary.felm"}.  It is quite similar to en \code{"summary.lm"}
object, but not entirely compatible.

The \code{"summary.felm"} object is a list containing the following fields:

\item{residuals}{a numerical vector. The residuals of the full system, with
dummies.}
\item{p}{an integer. The total number of coefficients, including
those projected out.}
\item{Pp}{an integer. The number of coefficients,
excluding those projected out.}
\item{coefficients}{a Pp x 4 matrix with
columns for the estimated coefficients, their standard errors, t-statistic
and corresponding (two-sided) p-value.}
\item{rse}{residual standard error.}
\item{r2}{R^2, the fraction of variance explained by the model.}
\item{r2adj}{Adjusted R^2.}
\item{fstat}{F-statistic.}
\item{pval}{P-values.}
\item{P.fstat}{Projected F-statistic. The result of a
call to \code{\link[=waldtest]{waldtest()}}}
\item{fe}{list of factors. A list of the
terms in the second part of the model.}
\item{lhs.}{character. If
\code{object} is the result of an estimation with multiple left hand sides,
the actual argument \code{lhs} will be copied to this field.}
\item{iv1fstat}{F-statistic for excluded instruments in 1. step IV, see
\code{\link[=felm]{felm()}}.}
\item{iv1pval}{P-value for \code{iv1fstat}.}
}
\description{
\code{summary} method for class \code{"felm"}.
}
\note{
The standard errors are adjusted for the reduced degrees of freedom
coming from the dummies which are implicitly present.  They are also
small-sample corrected.

If the \code{robust} parameter is \code{FALSE}, the returned object will
contain ordinary standard errors. If the \code{robust} parameter is
\code{TRUE}, clustered standard errors are reported if a cluster was
specified in the call to \code{felm}; if not, heteroskedastic robust
standard errors are reported.

Several F-statistics reported. The \code{P.fstat} is for the projected
system.  I.e. a joint test on whether all the \code{Pp} coefficients in
\code{coefficients} are zero.  Then there are \code{fstat} and \code{pval}
which is a test on all the coefficients including the ones projected out,
except for an intercept.  This statistic assumes i.i.d. errors and is not
reliable for robust or clustered data.

For a 1st stage IV-regression, an F-statistic against the model with
excluded instruments is also computed.
}
\seealso{
\code{\link[=waldtest]{waldtest()}}
}
