% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hash_sentiment_emojis.R
\docType{data}
\name{hash_sentiment_emojis}
\alias{hash_sentiment_emojis}
\title{Emoji Sentiment Polarity Lookup Table}
\format{A data frame with 734 rows and 2 variables}
\usage{
data(hash_sentiment_emojis)
}
\description{
A dataset containing an emoji identifier key and sentiment value.  This data
comes from Novak, Smailovic, Sluban, & Mozetic's (2015) emoji sentiment data.
The authors used Twitter data and 83 coders to rate each of the the emoji
uses as negative, neutral, or positive to form a probability distribution
(\eqn{p_{-}, p_{0}, p_{+}})
(\url{http://journals.plos.org/plosone/article/file?id=10.1371/journal.pone.0144296&type=printable})..
The sentiment score is calculated via the authors' formula:
\eqn{\frac{\sum{(-1*p_{-}, 0 * p_{0}, p_{+}})}{\sum{(p_{-}, p_{0}, p_{+}})}}.
This polarity lookup table differs from the other ones included in the
\pkg{lexicon} package in the the first column are not words but identifiers.
These identifiers are found in the \code{emojis_sentiment} data set.  The
typical use case is to utilize the \pkg{textclean} or \pkg{sentimentr}
packages' \code{replace_emoji} to swap out emojis for a
more computer friendly identifier.
}
\details{
\itemize{
  \item x. Words
  \item y. Sentiment
}
}
\section{Copyright}{
 2015 - Department of Knowledge Technologies
}

\references{
Novak, P. K., Smailovic, J., Sluban, B., and Mozetic, I. (2015)
Sentiment of emojis. PLoS ONE 10(12). doi:10.1371/journal.pone.0144296 \cr \cr
http://kt.ijs.si/data/Emoji_sentiment_ranking/index.html \cr \cr
https://creativecommons.org/licenses/by-sa/4.0/
}
\keyword{datasets}
