% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_office.R
\name{get_office}
\alias{get_office}
\title{Fetch 'Offices' table}
\format{
Data frame in wide format with columns (varies by legislature):
\itemize{
\item{wikidataid: Wikidata ID identifying a legislator's Wikidata entry (of class \sQuote{character}).}
\item{office_1: political or other office held by a legislator (of class \sQuote{logical}).}
\item{office_2: ... (of class \sQuote{logical}).}
\item{...}
}
}
\source{
Wikidata API, \url{https://www.wikidata.org/wiki/Wikidata:Main_Page}
}
\usage{
get_office(legislature)
}
\arguments{
\item{legislature}{A character string specifying the three-letter country code of the legislature for which data shall be fetched. Currently one of \sQuote{aut}, \sQuote{can}, \sQuote{cze}, \sQuote{esp}, \sQuote{fra}, \sQuote{deu}, \sQuote{irl}, \sQuote{sco}, \sQuote{gbr}, \sQuote{usa_house}, or \sQuote{usa_senate}.}
}
\value{
A data frame with columns as specified above.
}
\description{
Fetches political and other offices of legislators for the specified legislature. Requires a working Internet connection.
}
\examples{
\donttest{# Get entire 'Offices' table for the United States Senate
usa_offices <- get_office(legislature = "usa_senate")
tibble::glimpse(usa_offices)

# Get 'Offices' table for male members of the United States Senate
usa_offices_subset <- dplyr::semi_join(x = usa_offices,
                                       y = dplyr::filter(get_core(legislature = "usa_senate"),
                                                           sex == "female"),
                                         by = "wikidataid")
tibble::glimpse(usa_offices_subset)
}
}
