% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simu.star.app.R
\name{simu.star.app}
\alias{simu.star.app}
\title{Calculate simulated silhouette to area ratios from 'Ahmes' 1.0}
\usage{
simu.star.app(x, lat, long, tz, o.format = NULL, c.hour = NULL,
  c.date = NULL, c.long = NULL, c.lat = NULL, c.tz = NULL, LA = NULL,
  details = FALSE)
}
\arguments{
\item{x}{Output of 'Ahmes' 1.0. A .csv file.}

\item{lat}{A vector with the latitude of each observation in decimal format. If all observations correspond to the same latitude, \code{lat} can be introduced directly as a single number (see examples).}

\item{long}{A vector with the longitude of each observation in decimal format. If all observations correspond to the same longitude, \code{long} can be introduced directly as a single number (see examples).}

\item{tz}{A vector with the time zone of each observation. If all observations correspond to the same time zone, \code{tz} can be introduced directly as a single number (see examples). Time zones located at the West of Greenwich are negative, and at the East are positive; e.g., for Colombia, \code{tz} = -5; for Reunion Island, \code{tz} = 4.}

\item{o.format}{A character indicating the date format in the input data. It is similar to the argument \code{format} in the function \code{as.Date{base}}. Defaults to \code{NULL}. See details and examples.}

\item{c.hour}{A vector of custom hours of length equal to or greater than 1. Hours in decimal format, from 0 to 24. Minutes in decimal format, from 0 to 99. E.g., 12:30 should be written as 12.50. If available, seconds should also be specified in decimal format. See \code{\link{fixhour}}. If all observations correspond to the same local time, \code{local.time} can be introduced directly as a single number (see examples).}

\item{c.date}{A vector of custom dates of length equal to or greater than 1.}

\item{c.long}{A vector of custom longitude coordinates in decimal format.}

\item{c.lat}{A vector of custom latitude coordinates in decimal format.}

\item{c.tz}{A vector of custom time zone/s. Time zones located at the West of Greenwich are negative; e.g., for Colombia, \code{c.tz} = -5; for Reunion Island, \code{c.tz} = 4.}

\item{LA}{Indicates whether leaf area data needs to be replicated to match the dimensions of the dataframe corresponding to the custom factors (see 'custom settings' in Details). When \code{LA} is specified, all the five custom factors (\code{c.hour}, \code{c.date}, \code{c.lat}, \code{c.long}, \code{c.tz}) need to be specified (i.e., they should be different from \code{NULL}). Defaults to \code{NULL}. \code{LA} does not affect the calculation of STAR. See examples.}

\item{details}{Logical. If (\code{details =FALSE}), the output of \code{simu.star.app()} is a vector with STAR values. If \code{details = TRUE} the output is the complete dataset plus a column with STAR values. Defaults to \code{TRUE}.}
}
\description{
This is a version of simu.star function that only works with the output of 'Ahmes' 1.0. \code{simu.star.app()} re-calculates the percentage of potential exposure of flat, tilted surfaces to direct solar radiation with different custom settings of location and time.
}
\details{
This function calls \code{\link{fixfile}} internally before calculating STAR. However, it does not modify the original dataset. To have a permanent fixed version of the data, use \code{new.file<-fixfile(your.data)}. If using \code{new.file} within the package, be aware that the argument \code{Ahmes} should be set to \code{FALSE}.

\code{o.format} Needs to be specified if \code{Ahmes = FALSE} AND input data format is other than Julian or the default formats handled by \code{as.Date{base}} ("\%Y/\%m/\%d" and "\%Y-\%m-\%d"). When \code{Ahmes = TRUE}, \code{o.format} is not needed because functions of the \code{\link{Ahmes}} family solve date issues internally.

Custom settings. In the functions of the \code{simu} family, the original dataframe is repeated as a block times the number of levels of the custom arguments specified (\code{c.hour}, \code{c.date}, \code{c.lat}, \code{c.long}, and \code{c.tz}). E.g., if a dataset with 10 observations is to be recalculated at two days of the year, the function will create a new dataframe with 20 rows (10 observation X 2 days). For this reason, \code{LA} needs to be specified if the user intends to calculate SAL using the output of \code{simu.star}. In addition, the argument \code{details} allows the user to visualize the new dataframe created by the function.
}
\examples{
data(olea)
simustar_olea<-simu.star.app(olea,lat=40,long=4,tz=2,
 c.hour=c(8,12,18),c.date=c(1,60,120,180,240))

#simu.star.app()
}
\references{
\strong{Escribano-Rocafort, A.G., Ventre-Lespiaucq, A.B., Granado-Yela, C., Lopez-Pintor, A., Delgado, J.A., Munoz, V., Dorado, G.A., Balaguer, L. (2014).} Simplifying data acquisition in plant canopies- Measurements of leaf angles with a cell phone. Methods in Ecology and Evolution 5:132-140. doi:10.1111/2041-210X.12141.
}
\seealso{
\code{\link{fixfile}}, \code{\link{simu.star}}, \code{\link{star.app}}
}
\author{
Agustina Ventre-Lespiaucq and Silvia Santamaria Bueno.
}
\keyword{'Ahmes'}
\keyword{re-calculate}
\keyword{star}
