% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simu.star.R
\name{simu.star}
\alias{simu.star}
\title{Calculate simulated silhouette to area ratios}
\usage{
simu.star(x, lat = NULL, long = NULL, local.time = NULL, tz = NULL,
  Ahmes = F, ID = NULL, pitch, roll, tilt.ang = NULL, horiz = T, course,
  date = NULL, o.format = NULL, c.hour = NULL, c.date = NULL,
  c.long = NULL, c.lat = NULL, c.tz = NULL, LA = NULL, details = TRUE)
}
\arguments{
\item{x}{A dataframe with observations in the rows and at least two spatial position angles in the columns (see Details). Data can come either from 'Ahmes' 1.0 or from measurements performed with traditional instrumentation.}

\item{lat}{A vector with the latitude of each observation in decimal format. If all observations correspond to the same latitude, \code{lat} can be introduced directly as a single number (see examples).}

\item{long}{A vector with the longitude of each observation in decimal format. If all observations correspond to the same longitude, \code{long} can be introduced directly as a single number (see examples).}

\item{local.time}{A numeric vector with the local time of each observation in decimal format. Hours from 00 to 24. Minutes in decimal format, from 0 to 99. E.g., 12:30 should be written as 12.50. If available, seconds should also be specified in decimal format. See \code{\link{fixhour}}. If all observations correspond to the same local time, \code{local.time} can be introduced directly as a single number (see examples).}

\item{tz}{A vector with the time zone of each observation. If all observations correspond to the same time zone, \code{tz} can be introduced directly as a single number. Time zones located at the West of Greenwich are negative, and at the East are positive; e.g., for Colombia, \code{tz} = -5; for Reunion Island, \code{tz} = 4.}

\item{Ahmes}{Logical. Do data come from 'Ahmes' 1.0? Defaults to \code{FALSE}.}

\item{ID}{An optional vector with the labels of the observations. Defaults to \code{NULL}.}

\item{pitch}{A vector with pitch angles in degrees. See details.}

\item{roll}{A vector with roll rotation angles in degrees. See details.}

\item{tilt.ang}{A vector with tilt angles in degrees. Tilt is calculated from pitch and roll angles. This argument allows to specify tilt directly if available.}

\item{horiz}{Logical. Set the position of the start (zero, 0) of pitch, roll and tilt angle data. \code{horiz = F} indicates the zero is located at zenith. This is the reference system used by Ahmes. \code{horiz = T} indicates the start is at the horizon. To use tilt in further calculations (\code{\link{star}}, \code{\link{sal}}...), angle data should be expressed in the horizontal reference system (0 = horizon). Defaults to \code{TRUE}.}

\item{course}{A vector with course angles in degrees. See details.}

\item{date}{A vector containing the date(s) when observations were made. If input data do not come from 'Ahmes', \code{o.format} needs to be specified. See details.}

\item{o.format}{A character indicating the date format in the input data. It is similar to the argument \code{format} in the function \code{as.Date{base}}. Defaults to \code{NULL}. See details and examples.}

\item{c.hour}{A vector of custom hours of length equal to or greater than 1. Hours in decimal format, from 0 to 24. Minutes in decimal format, from 0 to 99. E.g., 12:30 should be written as 12.50. If available, seconds should also be specified in decimal format. See \code{\link{fixhour}}. If all observations correspond to the same local time, \code{local.time} can be introduced directly as a single number (see examples).}

\item{c.date}{A vector of custom dates of length equal to or greater than 1.}

\item{c.long}{A vector of custom longitude coordinates in decimal format.}

\item{c.lat}{A vector of custom latitude coordinates in decimal format.}

\item{c.tz}{A vector of custom time zone/s. Time zones located at the West of Greenwich are negative; e.g., for Colombia, \code{c.tz} = -5; for Reunion Island, \code{c.tz} = 4.}

\item{LA}{Indicates whether leaf area data needs to be replicated to match the dimensions of the dataframe corresponding to the custom factors (see 'custom settings' in Details). When \code{LA} is specified, all the five custom factors (\code{c.hour}, \code{c.date}, \code{c.lat}, \code{c.long}, \code{c.tz}) need to be specified (i.e., they should be different from \code{NULL}). Defaults to \code{NULL}. \code{LA} does not affect the calculation of STAR. See examples.}

\item{details}{Logical. If (\code{details =FALSE}) the output of \code{simu.star()} is a vector with STAR values. If \code{details = TRUE} the output is the complete dataset plus a column with STAR values. Defaults to \code{TRUE}.}
}
\description{
Recalculate the percentage of potential exposure of flat, tilted surfaces to direct solar radiation with different custom settings of location and time.
}
\details{
\code{x} may also content geographical coordinates and hour and date information.

\code{date} Internally the function uses Julian dates. Julian date is the recommended input format. Conversion tables are available at \url{https://landweb.nascom.nasa.gov/browse/calendar.html} for leap and regular years.

\code{o.format} Needs to be specified if \code{Ahmes = FALSE} AND input data format is other than Julian or the default formats handled by \code{as.Date{base}} ("\%Y/\%m/\%d" and "\%Y-\%m-\%d"). When \code{Ahmes = TRUE}, \code{o.format} is not needed because functions from the \code{\link{Ahmes}} family solve date issues internally.

\code{pitch} values span from 0 to 180 degrees. If \code{horiz = TRUE} (default) 0 and 180 refer to the flat horizontal surface and 90 refers to the flat vertical surface. If \code{horiz = FALSE} 0 and 180 refer to the flat vertical surface and 90 refers to the flat horizontal surface.

\code{roll} values span from 0 to 180 degrees.

\code{course} values span from 0 (North) to 360 degrees, clockwise. Course is the angle between north and the horizontal projection of a normal vector to the surface.

For a graphical explanation, see Fig. 2 in Escribano-Rocafort et al. (2014).

Custom settings. In the functions of the \code{simu} family, the original dataframe is repeated as a block times the number of levels of the custom arguments specified (\code{c.hour}, \code{c.date}, \code{c.lat}, \code{c.long}, and \code{c.tz}). E.g., if a dataset with 10 observations is to be recalculated at two days of the year, the function will create a new dataframe with 20 rows (10 observation X 2 days). For this reason, \code{LA} needs to be specified if the user intends to calculate SAL using the output of \code{simu.star()}. In addition, the argument \code{details} allows the user to visualize the new dataframe created by the function.
}
\examples{
\donttest{# With custom vectors from outside of the dataframe
 data(guava)
  myhours<-seq(8,16,0.25) # Create a vector of hours from 8:00 to 16:00 every 15 minutes.
  mydates<-seq(1,365,60) # Create a vector of days from January 1st to December 31st, 
                         # every 60 days.
  myguava<-simu.star(guava,lat=40.8,long=-4.2,local.time=6,tz=1,
           Ahmes=FALSE,ID=NULL,pitch=guava$pitch,roll=guava$roll,
           horiz=FALSE,course=guava$course,date=30,o.format=NULL,
           c.hour=myhours,c.date=mydates,c.long=NULL,c.lat=NULL, 
           c.tz=NULL, LA=NULL)

 # LA is not NULL
  wrong<-simu.star(guava,lat=40.8,long=-4.2,local.time=6,tz=1,
         Ahmes=FALSE,ID=NULL,pitch=guava$pitch,roll=guava$roll,
         horiz=FALSE,course=guava$course,date=30,o.format=NULL,
         c.hour=c(7,9.5,12),c.date=c(0,180),LA=guava$LA.cm2,details=TRUE)
     # Some custom settings are missing. STAR is retrieved as if LA = NULL, 
     # meaning LA data will not be readily available for calculating SAL. 

  correct<-simu.star(guava,lat=40.8,long=-4.2,local.time=6,tz=1,
           Ahmes=FALSE,ID=NULL,pitch=guava$pitch,roll=guava$roll,
           horiz=FALSE,course=guava$course,date=30,o.format=NULL,
           c.hour=c(7,9.5,12),c.date=c(0,180),c.lat=40.8,c.long=-4.2, 
           c.tz=1, LA=guava$LA.cm2,details=TRUE)
     # Returns LA and STAR

 # LA is NULL
  correct1<-simu.star(guava,lat=40.8,long=-4.2,local.time=6,tz=1,
            Ahmes=FALSE,ID=NULL,pitch=guava$pitch,roll=guava$roll,
            horiz=FALSE,course=guava$course,date=30,o.format=NULL,
            c.hour=c(7,9.5,12),c.date=c(0,180),c.long=NULL,c.lat=NULL, 
            c.tz=NULL, LA=NULL,details=TRUE)
          # Is the same as
  correct2<-simu.star(guava,lat=40.8,long=-4.2,local.time=6,tz=1,
            Ahmes=FALSE,ID=NULL,pitch=guava$pitch,roll=guava$roll,
            horiz=FALSE,course=guava$course,date=30,o.format=NULL,
            c.hour=c(7,9.5,12),c.date=c(0,180),details=TRUE)}
#simu.star() 
}
\references{
\strong{Escribano-Rocafort, A.G., Ventre-Lespiaucq, A.B., Granado-Yela, C., Lopez-Pintor, A., Delgado, J.A., Munoz, V., Dorado, G.A., Balaguer, L. (2014).} Simplifying data acquisition in plant canopies- Measurements of leaf angles with a cell phone. Methods in Ecology and Evolution 5:132-140. doi:10.1111/2041-210X.12141.
}
\seealso{
\code{\link{simu.star.app}}, \code{\link{star}}
}
\author{
Agustina Ventre-Lespiaucq and Silvia Santamaria Bueno.
}
\keyword{re-calculate}
\keyword{star}
