% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/in_condition.R
\name{in_condition}
\alias{in_condition}
\title{Create SQL string to select values included in a set of given values}
\usage{
in_condition(column_name, choices, negation = c("", "not"))
}
\arguments{
\item{column_name}{[character(1)]\cr
Name of data base column to select values from.}

\item{choices}{[character(1:Inf)] or [integer(1:Inf)]\cr
The values which must be matched. Character values must not contain any
single or double quotes to avoid problems with SQL syntax and for safety reasons.}

\item{negation}{[character(1)]\cr
If \code{"not"} the selection is inverted to a \code{NOT IN} expression.}
}
\value{
Character string to be used in SQL statement.
}
\description{
Create string with SQL \code{IN} expression for \code{WHERE} clause to select values
 included in a set of given values.
}
\details{
\code{column_name} must be a valid SQL identifier. It is validated to conform to
 the regular expression returned by \code{\link{valid_identifier_regex}}.
}
\examples{
# SQL expressions
lazysql::in_condition("COL_1", 1:3)

lazysql::in_condition("COL_1", 1:3, "not")

lazysql::in_condition("COL_1", LETTERS[2:3])

lazysql::in_condition("COL_1", LETTERS[2:3], "not")

}
\author{
Uwe Block
}
\seealso{
\code{\link{valid_identifier_regex}}.
}

