% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pool-estimates.R
\name{standardizedSolution.mi}
\alias{standardizedSolution.mi}
\alias{standardizedsolution.mi}
\title{Standardized Pooled Parameter Estimates}
\usage{
standardizedSolution.mi(
  object,
  return.vcov = FALSE,
  omit.imps = c("no.conv", "no.se"),
  ...
)
}
\arguments{
\item{object}{An object of class \code{lavaan.mi}}

\item{return.vcov}{\code{logical} indicating whether to return only the pooled
asymptotic covariance matrix, \code{vcov(object)}, but transformed for
standardized parameters. This is a way to obtain a pooled analog of
\code{lavInspect(object, "vcov.std.all")} with a \link[lavaan:lavaan-class]{lavaan::lavaan} object,
and it is how the \emph{SE}s are derived for standardized solutions.}

\item{omit.imps}{\code{character} indicating criteria for excluding imputations
from pooled results. See \linkS4class{lavaan.mi} for argument details.}

\item{\dots}{Arguments passed to \code{\link[lavaan:standardizedSolution]{lavaan::standardizedSolution()}}.}
}
\value{
A \code{data.frame} containing standardized model parameters, analogous to
\code{\link[lavaan:standardizedSolution]{lavaan::standardizedSolution()}}.  Delta-method \emph{SE}s and CIs rely on
asymptotic theory, so only Wald \emph{z} tests are available, analogous to
setting \code{parameterEstimates.mi(fit, asymptotic = TRUE)}.
}
\description{
This function calculates pooled parameter estimates from a lavaan model
fitted to multiple imputed data sets, then transforms the pooled estimates
and their \emph{SE}s using the delta method.
}
\examples{

data(HS20imps) # import a list of 20 imputed data sets

## specify CFA model from lavaan's ?cfa help page
HS.model <- '
  visual  =~ x1 + x2 + x3
  textual =~ x4 + x5 + x6
  speed   =~ x7 + x8 + x9
'
## fit model to 20 imputed data sets
fit <- cfa.mi(HS.model, data = HS20imps)

standardizedSolution.mi(fit) # default: type = "std.all"

## only standardize latent variables:
standardizedSolution.mi(fit, type = "std.lv",
                        output = "text") # display like summary()

}
\seealso{
\code{\link[=parameterEstimates.mi]{parameterEstimates.mi()}} for pooling unstandardized parameter estimates,
which can also add standardized point estimates to indicate effect size.
}
\author{
Terrence D. Jorgensen (University of Amsterdam;
\email{TJorgensen314@gmail.com})
}
