% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_nearestneighbour.R
\name{get_nearestneighbour}
\alias{get_nearestneighbour}
\title{get_nearestneighbour}
\usage{
get_nearestneighbour(landscape, return_id = FALSE)
}
\arguments{
\item{landscape}{SpatRaster or matrix (with x,y,id columns).}

\item{return_id}{If TRUE, also the patch ID of the nearest neighbour is returned.}
}
\description{
Euclidean distance to nearest neighbour
}
\details{
Fast and memory safe Rcpp implementation for calculating the minimum Euclidean
distances to the nearest patch of the same class in a raster or matrix.
All patches need an unique ID (see \code{\link{get_patches}}). Please be aware
that the patch ID is not identical to the patch ID of all metric functions (lsm_).
If \code{return_ID = TRUE}, for some focal patches several nearest neighbour patches
might be returned.

Because the metric is based on distances or areas please make sure your data
is valid using \code{\link{check_landscape}}.
}
\examples{
# get patches for class 1
landscape <- terra::rast(landscapemetrics::landscape)
class_1 <- get_patches(landscape, class = 2)[[1]][[1]]

# calculate the distance between patches
get_nearestneighbour(class_1)
get_nearestneighbour(class_1, return_id = TRUE)

}
\references{
Based on RCpp code of Florian Privé \email{florian.prive.21@gmail.com}
}
