% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GenerateData.R
\name{GenerateData}
\alias{GenerateData}
\title{Generate data}
\usage{
GenerateData(n, p, m, qvs, censoring.rate, simu.setting,
  covariate.dependent)
}
\arguments{
\item{n}{sample size, must be at least 1.}

\item{p}{number of populations, must be at least 2.}

\item{m}{number of different mixture proportions, must be at least 2.}

\item{qvs}{a numeric matrix of size \code{p} by \code{m} containing all possible
mixture proportions (i.e., the probability of belonging to each population k, k=1,...,p.).}

\item{censoring.rate}{a scalar indicating the censoring proportion. Options are 0 or 50.}

\item{simu.setting}{Character indicating simulation setting. Options are "1A", "1B", "2A","2B".
Setting "1A" and "1B" refer to Simulation setting 1 in the referenced paper, "1A" means the
survival outcomes do NOT depend on the covariates, and "1B" means the
survival outcomes do depend on the covariates.
Setting "2A" and "2B" refer to Simulation setting 2 in the referenced paper, "2A" means the
survival outcomes do NOT depend on the covariates, and "2B" means the
survival outcomes do depend on the covariates.}

\item{covariate.dependent}{logical indicator. If TRUE, then the survival times depend on covariates.}
}
\value{
Returns a list containing
\itemize{
   \item{x: }{a numeric vector of length \code{n} containing the observed event times
for each person in the sample.}
   \item{delta: }{a numeric vector of length \code{n} that denotes
censoring (1 denotes event is observed, 0 denotes event is censored).}
   \item{q: }{a numeric matrix of size \code{p} by \code{n} containing the
mixture proportions for each person in the sample.}
   \item{ww: }{a numeric vector of length \code{n} containing the values of the continuous
covariate for each person in the sample.}
   \item{zz: }{ a numeric vector of length \code{n} containing the values of the discrete
covariate for each person in the sample.}
   \item{true.groups: }{numeric vector of length \code{n} denoting the population identifier for each person in the sample.}
}
}
\description{
Produces data from different populations with the probability of
belonging to a population. Also produces one discrete covariate and one continuous covariate.
}
