% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/key.R
\name{key}
\alias{key}
\alias{key<-}
\title{Define a key for a data frame}
\usage{
key(.data, ..., .validate = TRUE, .strict = FALSE)

key(.data) <- value
}
\arguments{
\item{.data}{A data frame or tibble.}

\item{...}{Column names (unquoted) that form the key. Can be a single column
or multiple columns for a composite key.}

\item{.validate}{If \code{TRUE} (default), check that the key is unique.}

\item{.strict}{If \code{TRUE}, error on non-unique keys. If \code{FALSE} (default),
warn but still attach the key.}

\item{value}{Character vector of column names to use as key.}
}
\value{
A keyed data frame (class \code{keyed_df}).
}
\description{
Attaches key metadata to a data frame, marking which column(s) form the
unique identifier for rows. Keys are validated for uniqueness at creation.
}
\examples{
df <- data.frame(id = 1:3, x = c("a", "b", "c"))
key(df, id)

# Composite key
df2 <- data.frame(country = c("US", "US", "UK"), year = c(2020, 2021, 2020), val = 1:3)
key(df2, country, year)

}
