% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/snapshot.R
\name{commit_keyed}
\alias{commit_keyed}
\title{Commit a keyed data frame as reference}
\usage{
commit_keyed(.data, name = NULL)
}
\arguments{
\item{.data}{A data frame (preferably keyed).}

\item{name}{Optional name for the snapshot. If NULL, derived from data.}
}
\value{
Invisibly returns \code{.data} with snapshot metadata attached.
}
\description{
Stores a hash-based snapshot of the current data state.
Only one active reference per data frame (identified by its content hash).
}
\details{
The snapshot stores:
\itemize{
\item Row count
\item Column names and types
\item Hash of key columns (if keyed)
\item Hash of full content
}

Snapshots are stored in memory for the session. They are keyed by
content hash, so identical data shares the same snapshot.
}
\examples{
df <- key(data.frame(id = 1:3, x = c("a", "b", "c")), id)
df <- commit_keyed(df)

# Later, check for drift
df2 <- df
df2$x[1] <- "z"
check_drift(df2)

}
