% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kernel_study.R
\name{vonNeumann}
\alias{vonNeumann}
\title{Von Neumann entropy}
\usage{
vonNeumann(K)
}
\arguments{
\item{K}{Kernel matrix (class "matrix").}
}
\value{
Von Neumann entropy (a single value).
}
\description{
`vonNeumann()` computes the von Neumann entropy of a kernel matrix.
Entropy values close to 0 indicate that all its elements are very similar,
which may result in underfitting when training a prediction model. Instead,
values close to 1 indicate a high variability which may produce overfitting.
}
\examples{
data <- matrix(rnorm(150),ncol=50,nrow=30)
K <- Linear(data)
vonNeumann(K)
}
\references{
Belanche-Muñoz, L.A. and Wiejacha, M. (2023)
Analysis of Kernel Matrices via the von Neumann Entropy and Its Relation to RVM Performances.
Entropy, 25, 154. doi:10.3390/e25010154. \href{https://pmc.ncbi.nlm.nih.gov/articles/PMC9858626/}{Link}
}
