% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{plot.keras.src.models.model.Model}
\alias{plot.keras.src.models.model.Model}
\title{Plot a Keras model}
\usage{
\method{plot}{keras.src.models.model.Model}(
  x,
  show_shapes = FALSE,
  show_dtype = FALSE,
  show_layer_names = FALSE,
  ...,
  rankdir = "TB",
  expand_nested = FALSE,
  dpi = getOption("keras.plot.model.dpi", 200L),
  layer_range = NULL,
  show_layer_activations = FALSE,
  show_trainable = NA,
  to_file = NULL
)
}
\arguments{
\item{x}{A Keras model instance}

\item{show_shapes}{whether to display shape information.}

\item{show_dtype}{whether to display layer dtypes.}

\item{show_layer_names}{whether to display layer names.}

\item{...}{passed on to Python \code{keras.utils.model_to_dot()}. Used for forward and
backward compatibility.}

\item{rankdir}{a string specifying the format of the plot: \code{'TB'} creates a
vertical plot; \code{'LR'} creates a horizontal plot. (argument passed to PyDot)}

\item{expand_nested}{Whether to expand nested models into clusters.}

\item{dpi}{Dots per inch. Increase this value if the image text appears
excessively pixelated.}

\item{layer_range}{\code{list} containing two character strings, which is the
starting layer name and ending layer name (both inclusive) indicating the
range of layers for which the plot will be generated. It also accepts regex
patterns instead of exact name. In such case, start predicate will be the
first element it matches to \code{layer_range[1]} and the end predicate will be
the last element it matches to \code{layer_range[2]}. By default \code{NULL} which
considers all layers of model. Note that you must pass range such that the
resultant subgraph must be complete.}

\item{show_layer_activations}{Display layer activations (only for layers that
have an \code{activation} property).}

\item{show_trainable}{whether to display if a layer is trainable.}

\item{to_file}{File name of the plot image. If \code{NULL} (the default), the
model is drawn on the default graphics device. Otherwise, a file is saved.}
}
\value{
Nothing, called for it side effects.
}
\description{
Plot a Keras model
}
\section{Raises}{
 ValueError: if \code{plot(model)} is called before the model is
built, unless an \verb{input_shape = } argument was supplied to
\code{keras_model_sequential()}.
}

\section{Requirements}{

This function requires pydot and graphviz.

\code{pydot} is by default installed by \code{install_keras()}, but if you installed
Keras by other means, you can install \code{pydot} directly with:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{reticulate::py_install("pydot", pip = TRUE)
}\if{html}{\out{</div>}}

You can install graphviz directly from here:
\url{https://graphviz.gitlab.io/download/}

On most Linux platforms, can install graphviz via the package manager.
For example, on Ubuntu/Debian you can install with

\if{html}{\out{<div class="sourceCode sh">}}\preformatted{sudo apt install graphviz
}\if{html}{\out{</div>}}

On macOS you can install graphviz using \code{brew}:

\if{html}{\out{<div class="sourceCode sh">}}\preformatted{brew install graphviz
}\if{html}{\out{</div>}}

In a conda environment, you can install graphviz with:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{reticulate::conda_install(packages = "graphviz")
# Restart the R session after install.
}\if{html}{\out{</div>}}
}

