% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model-persistence.R
\name{get_registered_name}
\alias{get_registered_name}
\title{Returns the name registered to an object within the Keras framework.}
\usage{
get_registered_name(obj)
}
\arguments{
\item{obj}{The object to look up.}
}
\value{
The name associated with the object, or the default name if the
object is not registered.
}
\description{
This function is part of the Keras serialization and deserialization
framework. It maps objects to the string names associated with those objects
for serialization/deserialization.
}
\seealso{
Other serialization utilities: \cr
\code{\link{deserialize_keras_object}()} \cr
\code{\link{get_custom_objects}()} \cr
\code{\link{get_registered_object}()} \cr
\code{\link{register_keras_serializable}()} \cr
\code{\link{serialize_keras_object}()} \cr
\code{\link{with_custom_object_scope}()} \cr
}
\concept{serialization utilities}
