% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_magnitude.R
\name{set_magnitude_rate}
\alias{set_magnitude_rate}
\title{Set magnitude for rate-space numbers}
\usage{
set_magnitude_rate(x, mag = NULL, verbose = TRUE)
}
\arguments{
\item{x}{[num] numeric vector of rates (should be < 1)}

\item{mag}{[chr: default NULL] magnitude override: NULL (auto),
"per10", "per100", "per1k", "per10k", "per100k",
"per1m", "per10m", "per100m", "per1b", "per10b"}

\item{verbose}{[lgl: default TRUE] verbose warnings}
}
\value{
[data.frame] with columns: mag, mag_label, denom
}
\description{
Rates are values < 1 that are scaled up by dividing by small denominators (reciprocals).
E.g., 0.0000123 / 1e-5 = 1.23 "per 100,000"
}
\details{
Target: scaled value between 0.1 and 100
}
\seealso{
Other magnitudes: 
\code{\link{fmt_magnitude}()},
\code{\link{set_magnitude}()},
\code{\link{set_magnitude_count}()},
\code{\link{set_magnitude_prop}()}
}
\concept{magnitudes}
\keyword{internal}
