% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02_Norm.R
\name{Norm}
\alias{Norm}
\alias{d,Norm,numeric-method}
\alias{p,Norm,numeric-method}
\alias{qn,Norm,numeric-method}
\alias{r,Norm,numeric-method}
\alias{mean,Norm-method}
\alias{median,Norm-method}
\alias{mode,Norm-method}
\alias{var,Norm-method}
\alias{sd,Norm-method}
\alias{skew,Norm-method}
\alias{kurt,Norm-method}
\alias{entro,Norm-method}
\alias{finf,Norm-method}
\alias{llnorm}
\alias{ll,Norm,numeric-method}
\alias{enorm}
\alias{mle,Norm,numeric-method}
\alias{me,Norm,numeric-method}
\alias{vnorm}
\alias{avar_mle,Norm-method}
\alias{avar_me,Norm-method}
\title{Normal Distribution}
\usage{
Norm(mean = 0, sd = 1)

\S4method{d}{Norm,numeric}(distr, x, log = FALSE)

\S4method{p}{Norm,numeric}(distr, q, lower.tail = TRUE, log.p = FALSE)

\S4method{qn}{Norm,numeric}(distr, p, lower.tail = TRUE, log.p = FALSE)

\S4method{r}{Norm,numeric}(distr, n)

\S4method{mean}{Norm}(x)

\S4method{median}{Norm}(x)

\S4method{mode}{Norm}(x)

\S4method{var}{Norm}(x)

\S4method{sd}{Norm}(x)

\S4method{skew}{Norm}(x)

\S4method{kurt}{Norm}(x)

\S4method{entro}{Norm}(x)

\S4method{finf}{Norm}(x)

llnorm(x, mean, sd)

\S4method{ll}{Norm,numeric}(distr, x)

enorm(x, type = "mle", ...)

\S4method{mle}{Norm,numeric}(distr, x, na.rm = FALSE)

\S4method{me}{Norm,numeric}(distr, x, na.rm = FALSE)

vnorm(mean, sd, type = "mle")

\S4method{avar_mle}{Norm}(distr)

\S4method{avar_me}{Norm}(distr)
}
\arguments{
\item{mean, sd}{numeric. The distribution parameters.}

\item{distr}{an object of class \code{Norm}.}

\item{x}{For the density function, \code{x} is a numeric vector of quantiles. For
the moments functions, \code{x} is an object of class \code{Norm}. For the
log-likelihood and the estimation functions, \code{x} is the sample of
observations.}

\item{log, log.p}{logical. Should the logarithm of the probability be
returned?}

\item{q}{numeric. Vector of quantiles.}

\item{lower.tail}{logical. If TRUE (default), probabilities are
\eqn{P(X \leq x)}, otherwise \eqn{P(X > x)}.}

\item{p}{numeric. Vector of probabilities.}

\item{n}{number of observations. If \code{length(n) > 1}, the length is taken to
be the number required.}

\item{type}{character, case ignored. The estimator type (mle or me).}

\item{...}{extra arguments.}

\item{na.rm}{logical. Should the \code{NA} values be removed?}
}
\value{
Each type of function returns a different type of object:
\itemize{
\item Distribution Functions: When supplied with one argument (\code{distr}), the
\code{d()}, \code{p()}, \code{q()}, \code{r()}, \code{ll()} functions return the density, cumulative
probability, quantile, random sample generator, and log-likelihood functions,
respectively. When supplied with both arguments (\code{distr} and \code{x}), they
evaluate the aforementioned functions directly.
\item Moments: Returns a numeric, either vector or matrix depending on the moment
and the distribution. The \code{moments()} function returns a list with all the
available methods.
\item Estimation: Returns a list, the estimators of the unknown parameters. Note
that in distribution families like the binomial, multinomial, and negative
binomial, the size is not returned, since it is considered known.
\item Variance: Returns a named matrix. The asymptotic covariance matrix of the
estimator.
}
}
\description{
The Normal or Gaussian distribution, is an absolute continuous probability
distribution characterized by two parameters: the mean \eqn{\mu} and the
standard deviation \eqn{\sigma > 0}.
}
\details{
The probability density function (PDF) of the Normal distribution is:
\deqn{ f(x; \mu, \sigma) = \frac{1}{\sigma \sqrt{2\pi}} e^{-\frac{1}{2}
\left(\frac{x - \mu}{\sigma}\right)^2} .}
}
\examples{
# -----------------------------------------------------
# Normal Distribution Example
# -----------------------------------------------------

# Create the distribution
m <- 3 ; s <- 5
D <- Norm(m, s)

# ------------------
# dpqr Functions
# ------------------

d(D, c(0.3, 2, 10)) # density function
p(D, c(0.3, 2, 10)) # distribution function
qn(D, c(0.4, 0.8)) # inverse distribution function
x <- r(D, 100) # random generator function

# alternative way to use the function
df <- d(D) ; df(x) # df is a function itself

# ------------------
# Moments
# ------------------

mean(D) # Expectation
median(D) # Median
mode(D) # Mode
var(D) # Variance
sd(D) # Standard Deviation
skew(D) # Skewness
kurt(D) # Excess Kurtosis
entro(D) # Entropy
finf(D) # Fisher Information Matrix

# List of all available moments
mom <- moments(D)
mom$mean # expectation

# ------------------
# Point Estimation
# ------------------

enorm(x, type = "mle")
enorm(x, type = "me")

mle(D, x)
me(D, x)
e(D, x, type = "mle")

mle("norm", x) # the distr argument can be a character

# ------------------
# Estimator Variance
# ------------------

vnorm(m, s, type = "mle")
vnorm(m, s, type = "me")

avar_mle(D)
avar_me(D)

v(D, type = "mle")
}
\seealso{
Functions from the \code{stats} package: \code{\link[=dnorm]{dnorm()}}, \code{\link[=pnorm]{pnorm()}}, \code{\link[=qnorm]{qnorm()}},
\code{\link[=rnorm]{rnorm()}}
}
