% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jamba-plots.r
\name{usrBox}
\alias{usrBox}
\title{Draw colored box indicating R plot space}
\usage{
usrBox(
  fill = "#FFFF9966",
  label = NULL,
  parUsr = graphics::par("usr"),
  debug = FALSE,
  ...
)
}
\arguments{
\item{fill}{\code{character} R color used to fill the background of the plot}

\item{label}{\code{character} text optionally used to label the center of the
plot space, default \code{NULL}}

\item{parUsr}{\code{numeric} vector length 4, indicating the R plot space,
consistent with \code{graphics::par("usr")}. It can thus be used to define a
different area, though using the \code{\link[graphics]{rect}} function
directly seems more appropriate.}

\item{debug}{\code{logical} whether to print the parUsr value being used.}

\item{...}{additional arguments are ignored.}
}
\value{
no output, this function is called for the byproduct
of adding a box in the usr plot space of an R graphics device.
}
\description{
Draw colored box indicating the active R plot space
}
\details{
This function simply draws a box indicating the active plot space,
and by default it shades the box light yellow with transparency. It
can be useful to indicate the active plot area while allowing pre-drawn
plot elements to be shown, or can be useful precursor to provide a colored
background for the plot.

The plot space is defined using \code{graphics::par("usr")} and therefore requires
an active R device is already opened.
}
\examples{
# usrBox() requires that a plot device is already open
nullPlot(doBoxes=FALSE);
usrBox();

}
\seealso{
Other jam plot functions: 
\code{\link{adjustAxisLabelMargins}()},
\code{\link{coordPresets}()},
\code{\link{decideMfrow}()},
\code{\link{drawLabels}()},
\code{\link{getPlotAspect}()},
\code{\link{groupedAxis}()},
\code{\link{imageByColors}()},
\code{\link{imageDefault}()},
\code{\link{minorLogTicksAxis}()},
\code{\link{nullPlot}()},
\code{\link{plotPolygonDensity}()},
\code{\link{plotRidges}()},
\code{\link{plotSmoothScatter}()},
\code{\link{shadowText}()},
\code{\link{shadowText_options}()},
\code{\link{showColors}()},
\code{\link{sqrtAxis}()}
}
\concept{jam plot functions}
